package com.androidbook.media.audiorecord;

import android.app.Activity;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.util.Log;

public class MainActivity extends Activity {
	protected static final String TAG = "AudioRecord";
	private int mAudioBufferSize;
	private int mAudioBufferSampleSize;
	private AudioRecord mAudioRecord;
	private boolean inRecordMode = false;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		initAudioRecord();
	}

	@Override
	public void onResume() {
		super.onResume();
		Log.v(TAG, "Wznawianie...");
		inRecordMode = true;
		Thread t = new Thread(new Runnable() {

			@Override
			public void run() {
				getSamples();
			}
		});
		t.start();
	}

	protected void onPause() {
		Log.v(TAG, "Wstrzymywanie...");
		inRecordMode = false;
		super.onPause();
	}

	@Override
	protected void onDestroy() {
		Log.v(TAG, "Zamykanie...");
		if(mAudioRecord != null) {
			mAudioRecord.release();
            Log.v(TAG, "Zwolniono klase AudioRecord");			
		}
		super.onDestroy();
	}

	private void initAudioRecord() {
		try {
			int sampleRate = 8000;
			int channelConfig = AudioFormat.CHANNEL_IN_MONO;
			int audioFormat = AudioFormat.ENCODING_PCM_16BIT;
			mAudioBufferSize = 2 * AudioRecord.getMinBufferSize(sampleRate,
					channelConfig, audioFormat);
			mAudioBufferSampleSize = mAudioBufferSize / 2;
			mAudioRecord = new AudioRecord(
					MediaRecorder.AudioSource.MIC,
					sampleRate,
					channelConfig,
					audioFormat,
					mAudioBufferSize);
			Log.v(TAG, "Ustanawianie obiektu AudioRecord udane. Rozmiar buforu " + mAudioBufferSize);
			Log.v(TAG, "   Rozmiar buforu testowego = " + mAudioBufferSampleSize);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		}
		
		int audioRecordState = mAudioRecord.getState();
		if(audioRecordState != AudioRecord.STATE_INITIALIZED) {
			Log.e(TAG, "Obiekt AudioRecord zostal niewlasciwie zainicjowany");
			finish();
		}
		else {
			Log.v(TAG, "Obiekt AudioRecord zostal zainicjowany");
		}
	}
		
	private void getSamples() {
		if(mAudioRecord == null) return;

		short[] audioBuffer = new short[mAudioBufferSampleSize];

		mAudioRecord.startRecording();

		int audioRecordingState = mAudioRecord.getRecordingState();
		if(audioRecordingState != AudioRecord.RECORDSTATE_RECORDING) {
			Log.e(TAG, "Obiekt AudioRecord nie rejestruje dzwieku");
			finish();
		}
		else {
			Log.v(TAG, "Obiekt AudioRecord rozpoczal rejestrowanie dzwieku...");
		}

		while(inRecordMode) {
		    int samplesRead = mAudioRecord.read(audioBuffer, 0, mAudioBufferSampleSize);
		    Log.v(TAG, "Uzyskano probki: " + samplesRead);
		    Log.v(TAG, "Wartosci kilku pierwszych probek: " +
		    		audioBuffer[0] + ", " +
		    		audioBuffer[1] + ", " +
		    		audioBuffer[2] + ", " +
		    		audioBuffer[3] + ", " +
		    		audioBuffer[4] + ", " +
		    		audioBuffer[5] + ", " +
		    		audioBuffer[6] + ", " +
		    		audioBuffer[7] + ", " +
		    		audioBuffer[8] + ", " +
		    		audioBuffer[9] + ", "
		    		);
		}
		
		mAudioRecord.stop();
		Log.v(TAG, "Obiekt AudioRecord zakonczyl proces rejestrowania");
	}
}