package com.androidbook.fragments.bard;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class DetailsFragment extends Fragment {
	
	private int mIndex = 0;

	public static DetailsFragment newInstance(int index) {
        Log.v(MainActivity.TAG, "w metodzie newInstance(" + index + ")klasy DetailsFragment");

        DetailsFragment df = new DetailsFragment();

        // Dostarcza indeks w postaci argumentu.
		Bundle args = new Bundle();
		args.putInt("indeks", index);
		df.setArguments(args);
		return df;
	}
	
	public static DetailsFragment newInstance(Bundle bundle) {
		int index = bundle.getInt("indeks", 0);
        return newInstance(index);
	}

    @Override
    public void onInflate(AttributeSet attrs, Bundle savedInstanceState) {
    	Log.v(MainActivity.TAG,
    			"w metodzie onInflate klasy DetailsFragment. Interfejs AttributeSet zawiera:");
    	for(int i=0; i<attrs.getAttributeCount(); i++)
            Log.v(MainActivity.TAG, "    " + attrs.getAttributeName(i) +
            		" = " + attrs.getAttributeValue(i));
    	super.onInflate(attrs, savedInstanceState);
    }

	@Override
    public void onAttach(Activity myActivity) {
    	Log.v(MainActivity.TAG, "w metodzie onAttach klasy DetailsFragment; aktywnoscia jest: " +
    			myActivity);
    	super.onAttach(myActivity);
    }

    @Override
    public void onCreate(Bundle myBundle) {
    	Log.v(MainActivity.TAG, "w metodzie onCreate klasy DetailsFragment. Pakiet zawiera:");
    	if(myBundle != null) {
            for(String key : myBundle.keySet()) {
                Log.v(MainActivity.TAG, "    " + key);
            }
    	}
    	else {
            Log.v(MainActivity.TAG, "    Obiekt myBundle jest pusty");
    	}
    	super.onCreate(myBundle);

    	mIndex = getArguments().getInt("indeks", 0);
    }

    public int getShownIndex() {
    	return mIndex;
    }

	@Override
	public View onCreateView(LayoutInflater inflater,
			ViewGroup container, Bundle savedInstanceState) {
        Log.v(MainActivity.TAG, "w metodzie onCreateView klasy DetailsFragment. pojemnik = " +
        		container);

        // Nie wimy tego fragmentu z niczym za pomoc obiektu pompujcego.
        // Android zajmuje si za nas przyczaniem fragmentw.
        // Pojemnik jest jedynie przepuszczany, wic wiemy dziki niemu
        // dokd trafi hierarchia widokw.
		View v = inflater.inflate(R.layout.details, container, false);
		TextView text1 = (TextView) v.findViewById(R.id.text1);
		text1.setText(Shakespeare.DIALOGUE[ mIndex ] );
		return v;
	}

    @Override
    public void onActivityCreated(Bundle savedState) {
    	Log.v(MainActivity.TAG,
    			"w metodzie onActivityCreated klasy DetailsFragment. Klasa savedState zawiera:");
    	if(savedState != null) {
            for(String key : savedState.keySet()) {
                Log.v(MainActivity.TAG, "    " + key);
            }
    	}
    	else {
            Log.v(MainActivity.TAG, "    Klasa savedState jest pusta");
    	}
        super.onActivityCreated(savedState);
    }

    @Override
    public void onStart() {
    	Log.v(MainActivity.TAG, "w metodzie onStart klasy DetailsFragment");
    	super.onStart();
    }

    @Override
    public void onResume() {
    	Log.v(MainActivity.TAG, "w metodzie onResume klasy DetailsFragment");
    	super.onResume();
    }

    @Override
    public void onPause() {
    	Log.v(MainActivity.TAG, "w metodzie onPause klasy DetailsFragment");
    	super.onPause();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    	Log.v(MainActivity.TAG, "w metodzie onSaveInstanceState klasy DetailsFragment");
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onStop() {
    	Log.v(MainActivity.TAG, "w metodzie onStop klasy DetailsFragment");
    	super.onStop();
    }

    @Override
    public void onDestroyView() {
    	Log.v(MainActivity.TAG, "w metodzie onDestroyView klasy DetailsFragment, widok = " +
    			getView());
    	super.onDestroyView();
    }

    @Override
    public void onDestroy() {
    	Log.v(MainActivity.TAG, "w metodzie onDestroy klasy DetailsFragment");
    	super.onDestroy();
    }

    @Override
    public void onDetach() {
    	Log.v(MainActivity.TAG, "w metodzie onDetach klasy DetailsFragment");
    	super.onDetach();
    }
}