package com.androidbook.fragments.dialogs;

import android.app.Activity;
import android.app.DialogFragment;
import android.app.FragmentTransaction;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class PromptDialogFragment 
extends DialogFragment 
implements View.OnClickListener
{
	private EditText et;

	public static PromptDialogFragment
	newInstance(String prompt)
	{
		PromptDialogFragment pdf = new PromptDialogFragment();
		Bundle bundle = new Bundle();
		bundle.putString("zachta",prompt);
		pdf.setArguments(bundle);
		
		return pdf;
	}

	@Override
	public void onAttach(Activity act) {
	      // Jeeli aktywno, do ktrej doczylimy nie
	      // posiada zaimplementowanego interfejsu OnDialogDoneListener,
	      // poniszy wiersz spowoduje wywietlenie wyjtku
	      // ClassCastException. Jest to najwczeniejszy etap,
	      // w ktrym moemy przetestowa zachowanie aktywnoci.
		OnDialogDoneListener test = (OnDialogDoneListener)act;
		super.onAttach(act);
	}

    @Override    
    public void onCreate(Bundle icicle)
    {
    	super.onCreate(icicle);
    	this.setCancelable(true);
        int style = DialogFragment.STYLE_NORMAL, theme = 0;
        setStyle(style,theme);
    }

    public View onCreateView(LayoutInflater inflater,            
    		ViewGroup container, 
    		Bundle icicle)
    {
        View v = inflater.inflate(
        		R.layout.prompt_dialog, container, false);

        TextView tv = (TextView)v.findViewById(
        		                   R.id.promptmessage);
        tv.setText(getArguments().getString("zachta"));

        Button dismissBtn = (Button)v.findViewById(
        		                       R.id.btn_dismiss);
        dismissBtn.setOnClickListener(this);

        Button saveBtn = (Button)v.findViewById(
        		                    R.id.btn_save);
        saveBtn.setOnClickListener(this);

        Button helpBtn = (Button)v.findViewById(
                R.id.btn_help);
        helpBtn.setOnClickListener(this);

        et = (EditText)v.findViewById(R.id.inputtext);
        if(icicle != null)
            et.setText(icicle.getCharSequence("wejcie"));
        return v;
    }

    @Override
    public void onSaveInstanceState(Bundle icicle) {
    	icicle.putCharSequence("wejcie", et.getText());
    	super.onPause();
    }

    @Override
    public void onCancel(DialogInterface di) {
    	Log.v(MainActivity.LOGTAG, "w metodzie onCancel () fragmentu PDF");
    	super.onCancel(di);
    }

    @Override
    public void onDismiss(DialogInterface di) {
    	Log.v(MainActivity.LOGTAG, "w metodzie onDismiss() fragmentu PDF");
    	super.onDismiss(di);
    }

    public void onClick(View v) 
	{
		OnDialogDoneListener act = (OnDialogDoneListener)getActivity();
		if (v.getId() == R.id.btn_save)
		{
			TextView tv = (TextView)getView().findViewById(R.id.inputtext);
			act.onDialogDone(this.getTag(), false, tv.getText());
			dismiss();
			return;
		}
		if (v.getId() == R.id.btn_dismiss)
		{
			act.onDialogDone(this.getTag(), true, null);
			dismiss();
			return;
		}
		if (v.getId() == R.id.btn_help)
		{
			FragmentTransaction ft = getFragmentManager().beginTransaction();
		    ft.remove(this);

		    // w tym przypadku chcemy wywietli tekst pomocy i
	        // po zakoczeniu powrci do poprzedniego okna dialogowego
		    ft.addToBackStack(null);
		    //warto null oznacza brak nazwy dla transakcji stosu drugoplanowego

		    HelpDialogFragment hdf =
		    	    HelpDialogFragment.newInstance(R.string.help1);
		    hdf.show(ft, MainActivity.HELP_DIALOG_TAG);
		    return;
		}
	}
}
