package com.androidbook.contacts;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Log;

public class AggregatedContactFunctionTester extends URIFunctionTester 
{
	public AggregatedContactFunctionTester(Context ctx, IReportBack target)
	{
		super(ctx, target);
	}
	/*
	 * Pobiera kursor ze wszystkich kontaktw
     * Bez klauzuli where
     * Nie stosujmy tego w przypadku duego zbioru
	 */
    private Cursor getContacts()
    {
        // Uruchamia kwerend
        Uri uri = ContactsContract.Contacts.CONTENT_URI;
        String sortOrder = ContactsContract.Contacts.DISPLAY_NAME 
                             + " COLLATE LOCALIZED ASC";
        Activity a = (Activity)this.mContext;
        return a.managedQuery(uri, null, null, null, sortOrder);
    }
    
    /*
     * Wykorzystuje powysz metod getContacts
     * do utworzenia spisu kolumn zawartych w kursorze
     */
	public void listContactCursorFields()
	{
		Cursor c = null;
		try
		{
			c = getContacts();
			int i = c.getColumnCount();
			this.mReportTo.reportBack(tag, "Ilo kolumn:" + i);
			this.printCursorColumnNames(c);
		}
		finally
		{
			if (c!= null) c.close();
		}
	}

	/*
     * Przy uyciu kursora wypenionego kontaktami
     * zostaj wywietlone nazwy kontaktw wraz z
     * ich kluczami wyszukiwania
	 */
	private void printLookupKeys(Cursor c)
	{
		for(c.moveToFirst();!c.isAfterLast();c.moveToNext())
		{
			String name=this.getContactName(c);
			String lookupKey = this.getLookupKey(c);
			String luri = this.getLookupUri(lookupKey);
			this.mReportTo.reportBack(tag, name + ":" + lookupKey);
			this.mReportTo.reportBack(tag, name + ":" + luri);
		}
	}

	/*
     * Wykorzystuje funkcj getContacts()
     * do uzyskania kursora i wywietlenia wszystkich
     * nazw kontaktw wraz z kluczami ich wyszukiwania
     * stosuje funkcj printLookyupKeus()
	 */
	public void listContacts()
	{
		Cursor c = null;
		try
		{
			c = getContacts();
			int i = c.getColumnCount();
			this.mReportTo.reportBack(tag, "Ilo kolumn:" + i);
			this.printLookupKeys(c);
		}
		finally
		{
			if (c!= null) c.close();
		}
	}
	
	/*
     * Funkcja uytkowa odczytujca
     * klucz wyszukiwania z kursora kontaktu
	 */
	private String getLookupKey(Cursor cc)
    {
    	int lookupkeyIndex = cc.getColumnIndex(ContactsContract.Contacts.LOOKUP_KEY);
    	return cc.getString(lookupkeyIndex);
    }
	
	/*
     * Funkcja uytkowa odczytujca
     * wywietlan nazw z kursora kontaktu
	 */
    private String getContactName(Cursor cc)
    {
    	return Utils.getColumnValue(cc,ContactsContract.Contacts.DISPLAY_NAME);
    }

    /**
     * Konstruuje identyfikator wyszukiwania w oparciu o
     * Identyfikator URI kontaktw i klucz wyszukiwania
     */
    private String getLookupUri(String lookupkey)
    {
    	String luri = ContactsContract.Contacts.CONTENT_LOOKUP_URI + "/" + lookupkey;
    	return luri;
    }
    
    /**
     * Wykorzystuje identyfikator URI wyszukiwania
     * do odczytania pojedynczego kontaktu zbiorczego
     */
    private Cursor getASingleContact(String lookupUri)
    {
    	// Uruchamia kwerend
        Activity a = (Activity)this.mContext;
        return a.managedQuery(Uri.parse(lookupUri), null, null, null, null);
    }

    /*
     * Funkcja sprawdzajca, czy identyfikator URI stworzony za pomoc identyfikatora
     * URI wyszukiwania zwraca kursor zawierajcy inny zestaw kolumn.
     * Jak mona byo si spodziewa, zwracany jest podobny kursor 
     * zawierajcy podobny zbir kolumn.
     */
	public void listLookupUriColumns()
	{
		Cursor c = null;
		try
		{
			c = getContacts();
			String firstContactLookupUri = getFirstLookupUri(c);
			printLookupUriColumns(firstContactLookupUri);
		}
		finally
		{
			if (c!= null) c.close();
		}
	}
	
	public void printLookupUriColumns(String lookupuri)
	{
		Cursor c = null;
		try
		{
			c = getASingleContact(lookupuri);
			int i = c.getColumnCount();
			this.mReportTo.reportBack(tag, "Ilo kolumn:" + i);
			int j = c.getCount();
			this.mReportTo.reportBack(tag, "Ilo wierszy:" + j);
			this.printCursorColumnNames(c);
		}
		finally
		{
			if (c!=null)c.close();
		}
	}

	/*
     * Pobiera list kontaktw
     * Wyszukuje pierwszy kontakt
     * Zwraca warto null, jeli nie znajdzie adnego kontaktu
	 */
	private String getFirstLookupUri(Cursor c)
	{
		c.moveToFirst();
		if (c.isAfterLast())
		{
			Log.d(tag,"Brak wierszy, z ktorych mozna pobrac pierwszy kontakt");
			return null;
		}
		//Znaleziono wiersz
		String lookupKey = this.getLookupKey(c);
		String luri = this.getLookupUri(lookupKey);
		return luri;
	}

	/*
     * Pobiera list kontaktw
     * wyszukuje pierwszy kontakt i zwraca go
     * w formie obiektu AggregatedContact.
	 */
	protected AggregatedContact getFirstContact()
	{
		Cursor c=null;
		try
		{
			c = getContacts();
			c.moveToFirst();
			if (c.isAfterLast())
			{
				Log.d(tag,"Brak kontaktow");
				return null;
			}
			//znaleziono kontakt
			AggregatedContact firstcontact = new AggregatedContact();
			firstcontact.fillinFrom(c);
			return firstcontact;
		}
		finally
		{
			if (c!=null) c.close();
		}
	}
}
