package com.ai.android.sampledialogs;

import android.app.AlertDialog;
import android.app.Dialog;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends ManagedDialogsActivity 
implements IStringPrompterCallBack
{
	
	private final static String tag = "MainActivity";
	
	private GenericManagedAlertDialog gmad = 
		new GenericManagedAlertDialog(this,1,"Prosty, przykadowy alert");
	
	private GenericPromptDialog gmpd = 
		new GenericPromptDialog(this,2,"Tutaj umieszczamy tekst");
	
	//Jest inicjowana w metodzie onCreateOptions
	Menu myMenu = null;
	
    /** Wywoywane podczas pierwszego utworzenia aktywnoci. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.main);
        this.registerDialogs();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) 
    {
    	//wywouje obiekt nadrzdny w celu doczenia menu systemowych
    	super.onCreateOptionsMenu(menu);
    	
    	this.myMenu = menu;

    	MenuInflater mi = this.getMenuInflater();
    	mi.inflate(R.menu.main_menu,menu);
    	
    	return true;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) 
    {
    	try
    	{
    		handleMenus(item);
    	}
    	catch(Throwable t)
    	{
    		Log.d(tag,t.getMessage(),t);
    		throw new RuntimeException("blad",t);
    	}
    	return true;
    	
    }
    private void handleMenus(MenuItem item)
    {
		this.appendMenuItemText(item);
		if (item.getItemId() == R.id.menu_clear)
		{
			this.emptyText();
		}
		else if (item.getItemId() == R.id.menu_simple_alert)
		{
	    	this.exerciseSimpleAlertDialog();
		}
		else if (item.getItemId() == R.id.menu_simple_prompt)
		{
	    	this.exerciseSimplePromptDialog();
		}
		else if (item.getItemId() == R.id.menu_toast)
		{
	    	this.testToast();
		}
    }
    
    private TextView getTextView()
    {
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	return tv;
    }
    public void appendText(String text)
    {
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	tv.setText(tv.getText() + text);
    }
    public void appendMenuItemText(MenuItem menuItem)
    {
    	String title = menuItem.getTitle().toString();
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	tv.setText(tv.getText() + "\n" + title + ":" + menuItem.getItemId());
    }
    private void emptyText()
    {
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	tv.setText("");
    }
	public void promptCallBack(String promptedString, 
			int buttonPressed, //Ktry przycisk zosta wcinity 
			int actionId) //Suy do obsugi wielu wystpie zachty
	{
		if (buttonPressed == IStringPrompterCallBack.OK_BUTTON)
		{
			this.appendText("\ncig znakw zachty wynosi:" + promptedString);
		}
		else
		{
			this.appendText("\nZamiast tego wcinito przycisk Anuluj");
		}
	}
	private void exercisePrompt()
	{
		Alerts.Prompt(this,"Prosimy wprowadzi nazw pliku", this,1);
	}
	
	private int alertDemoCounter=0;
	
    //ustawiamy to 
    private String dynamicMessage = "Pocztkowy komunikat";
    private Dialog createAlertDialog()
    {
    	return Alerts.createAlertDialog(dynamicMessage, this);
    }
    
    private void prepareAlertDialog(Dialog d)
    {
    	AlertDialog ad = (AlertDialog)d;
    	ad.setMessage(dynamicMessage);
    }
    
    private void exerciseSimpleAlertDialog()
    {
    	this.gmad.show();
    }
    private void exerciseSimplePromptDialog()
    {
    	this.gmpd.show();
    }
    private void exerciseAlertDialog()
    {
    	this.dynamicMessage="Dynamiczny komunikat:" + alertDemoCounter++;
    	showDialog(this.gmad.getDialogId());
    }
    protected void registerDialogs()
    {
    	registerDialog(gmad);
    	registerDialog(this.gmpd);
    }
    private void exerciseDialogRegistry()
    {
    	gmad.setAlertMessage("jaki komunikat:" + this.alertDemoCounter++);
    	gmad.show();
    }
    private void testToast()
    {
    	reportToast("Komunikat1");
    	reportToast("Komunikat2");
    	reportToast("Komunikat3");
    }
	public void reportToast(String message)
	{
		String s = tag + ":" + message;
		Toast mToast = Toast.makeText(this, s, Toast.LENGTH_SHORT);
		mToast.show();
		Log.d(tag,message);
	}
	public void dialogFinished(ManagedActivityDialog dialog, int buttonId)
	{
		if (dialog instanceof GenericPromptDialog)
		{
			this.appendText("\n" + this.gmpd.getPromptValue());
		}
	}
}//eof-class