package com.ai.android.book.resources;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;

public class MonitoredActivity extends Activity
{
	private String tag = null;
	MonitoredActivity(String intag) {tag = intag;}
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		Log.d(tag,"Metoda onCreate.");
		super.onCreate(savedInstanceState);
	}
	@Override
	protected void onPause() {
		Log.d(tag,"Metoda onpause. Moge byc czesciowo lub calkowicie niewidoczna");
		super.onPause();
	}
	@Override
	protected void onStop() {
		Log.d(tag,"Metoda onstop. Jestem calkowicie niewidoczna");
		super.onStop();
	}
	@Override
	protected void onDestroy() {
		Log.d(tag,"Metoda ondestroy. Za chwile zostane usunieta");
		super.onDestroy();
	}
	@Override
	protected void onRestart() {
		Log.d(tag,"Metoda onRestart. Tutaj znajduja sie kontrolki interfejsu uzytkownika.");
		super.onRestart();
	}
	@Override
	protected void onStart() {
		Log.d(tag,"Metoda onStart. Interfejs uzytkownika moze byc czesciowo widoczny.");
		super.onStart();
	}
	@Override
	protected void onResume() {
		Log.d(tag,"Metoda onResume. Interfejs uzytkownika jest w pelni widoczny.");
		super.onResume();
	}
	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		Log.d(tag,"Metoda onRestoreInstanceState. Powinnismy przywrocic poprzedni stan");
		super.onRestoreInstanceState(savedInstanceState);
	}

	@Override
	public Object onRetainNonConfigurationInstance() {
		Log.d(tag,"Metoda onRetainNonConfigurationInstance.");
		return super.onRetainNonConfigurationInstance();
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		Log.d(tag,"Metoda onSaveInstanceState. Powinnismy zapisac stan w pakiecie");
		super.onSaveInstanceState(outState);
	}
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		Log.d(tag,"Metoda onConfigurationChanged.");
		super.onConfigurationChanged(newConfig);
	}

}
