package com.androidbook.OpenGL;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.os.SystemClock;

//nazwa pliku: PolygonRenderer.java
public class PolygonRenderer extends AbstractRenderer
{
	//Ilo uywanych punktw lub wierzchokw
    private final static int VERTS = 4;
    
  //Nieskompresowany bufor natywny, przechowujcy wsprzdne punktw
    private FloatBuffer mFVertexBuffer;
    
    //Nieskompresowany bufor natywny, przechowujcy indeksy
    //umoliwiajce wielokrotne wykorzystywanie punktw.
    private ShortBuffer mIndexBuffer;
    
    private int numOfIndecies = 0;
    
    private long prevtime = SystemClock.uptimeMillis();
    
    private int sides = 3;
    
    public PolygonRenderer(Context context) 
    {
    	//EvenPolygon t = new EvenPolygon(0,0,0,1,3);
    	//EvenPolygon t = new EvenPolygon(0,0,0,1,4);
    	prepareBuffers(sides);
    }
    
    private void prepareBuffers(int sides)
    {
    	RegularPolygon t = new RegularPolygon(0,0,0,1,sides);
    	//RegularPolygon t = new RegularPolygon(1,1,0,1,sides);
    	this.mFVertexBuffer = t.getVertexBuffer();
    	this.mIndexBuffer = t.getIndexBuffer();
    	this.numOfIndecies = t.getNumberOfIndecies();
        this.mFVertexBuffer.position(0);
        this.mIndexBuffer.position(0);
    }

  //przesonita metoda
    protected void draw(GL10 gl)
    {
        long curtime = SystemClock.uptimeMillis();
        if ((curtime - prevtime) > 2000)
        {
        	prevtime = curtime;
        	sides += 1;
        	if (sides > 20)
        	{
        		sides = 3;
        	}
            this.prepareBuffers(sides);
        }
    	//EvenPolygon.test();
    	gl.glColor4f(1.0f, 0, 0, 0.5f);
    	gl.glVertexPointer(3, GL10.GL_FLOAT, 0, mFVertexBuffer);
    	gl.glDrawElements(GL10.GL_TRIANGLES, this.numOfIndecies,
                GL10.GL_UNSIGNED_SHORT, mIndexBuffer);
    }
}
