package com.androidbook.salbcr;

import android.content.Intent;
import android.util.Log;

/*
 * Wykorzystuje usug IntentService jako klas bazow
 * w celu umieszczenia poniszych operacji w osobnym wtku.
 */
public class Test60SecBCRService 
extends ALongRunningNonStickyBroadcastService
{
	public static String tag = "Test60SecBCRService";
	
	//Wymagana przez usug IntentService
	public Test60SecBCRService()
	{
		super("com.ai.android.service.Test60SecBCRService");
	}
	
	/*
	 * Przeprowadza wewntrz tej metody dugotrwae operacje.
	 * S one przeprowadzane w oddzielnym wtku. 
	 */
	@Override
	protected void handleBroadcastIntent(Intent broadcastIntent) 
	{
		Utils.logThreadSignature(tag);
		Log.d(tag,"Przejscie w stan bezczynnosci na 60 sekund");
		Utils.sleepForInSecs(60);
		String message = 
			broadcastIntent.getStringExtra("message");
		Log.d(tag,"Praca wykonana");
		Log.d(tag,message);
	}
}
