package com.androidbook.sensors.list;

//Jest to plik MainActivity.java
import java.util.HashMap;
import java.util.List;
import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.widget.TextView;

public class MainActivity extends Activity {
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        TextView text = (TextView)findViewById(R.id.text);

        SensorManager mgr = (SensorManager) this.getSystemService(SENSOR_SERVICE);

        List<Sensor> sensors = mgr.getSensorList(Sensor.TYPE_ALL);

        StringBuilder message = new StringBuilder(2048);
        message.append("Czujniki znalezione w urzdzeniu:\n");
        
        for(Sensor sensor : sensors) {
        	message.append(sensor.getName() + "\n");
        	message.append("  Typ: " + sensorTypes.get(sensor.getType()) + "\n");
        	message.append("  Producent: " + sensor.getVendor() + "\n");
        	message.append("  Wersja: " + sensor.getVersion() + "\n");
        	message.append("  Rozdzielczo: " + sensor.getResolution() + "\n");
        	message.append("  Maksymalny zasig: " + sensor.getMaximumRange() + "\n");
        	message.append("  Zasilanie: " + sensor.getPower() + " mA\n");
        }
        text.setText(message);
    }
    
    private HashMap<Integer, String> sensorTypes = new HashMap<Integer, String>();

    { // Inicjujemy powizanie wartoci typu sensora z jego nazw
    	sensorTypes.put(Sensor.TYPE_ACCELEROMETER, "TYP_AKCELEROMETR"); // 1
    	sensorTypes.put(Sensor.TYPE_GYROSCOPE, "TYP_YROSKOP"); // 4
    	sensorTypes.put(Sensor.TYPE_LIGHT, "TYP_OWIETLENIE"); // 5
    	sensorTypes.put(Sensor.TYPE_MAGNETIC_FIELD, "TYP_POLE_MAGNETYCZNE"); // 2
    	sensorTypes.put(Sensor.TYPE_ORIENTATION, "TYP_ORIENTACJA"); // 3
    	sensorTypes.put(Sensor.TYPE_PRESSURE, "TYP_CINIENIE"); // 6
    	sensorTypes.put(Sensor.TYPE_PROXIMITY, "TYP_ODLEGO"); // 8
    	sensorTypes.put(Sensor.TYPE_TEMPERATURE, "TYP_TEMPERATURA"); // 7
		sensorTypes.put(Sensor.TYPE_GRAVITY, "TYP_GRAWITACJA"); // 9
        sensorTypes.put(Sensor.TYPE_LINEAR_ACCELERATION,
                              "TYP_PRZYPIESZENIE_LINIOWE"); // 10
        sensorTypes.put(Sensor.TYPE_ROTATION_VECTOR,
                              "TYP_WEKTOR_OBROTU"); // 11
    }
}