package com.androidbook.salbcr;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

/*
 * Jest to zastpczy odbiorca komunikatw,
 * delegujcy prac do usugi,
 * ktrego nazwa wywodzi si od odpowiedniej klasy.
 * 
 * Oryginalna intencja, za pomoc ktrej odbiorca
 * komunikatw jest wywoywany, zostaje przeniesiona 
 * do delegowanej, krtkotrwaej usugi, w ktrej bdzie
 * przetwarzana jako obiekt Parcellable.
 * 
 * Na samym pocztku zostanie skonfigurowany 
 * zielony, owietlony pokj. Zasadniczo urzdzenie zostanie wczone.
 * 
 * Jeeli urzdzenie ma zosta wybudzone przez intencje oczekujce,
 * takie samo przeznaczenie bdzie posiadaa usuga.
 */
public abstract class  ALongRunningReceiver 
extends BroadcastReceiver 
{
	private static final String tag = "ALongRunningReceiver"; 
    @Override
    public void onReceive(Context context, Intent intent) 
    {
    	Log.d(tag,"Odbiorca uruchomiony");
    	LightedGreenRoom.setup(context);
    	startService(context,intent);
    	Log.d(tag,"Odbiorca zakonczony");
    }
    private void startService(Context context, Intent intent)
    {
    	Intent serviceIntent = new Intent(context,getLRSClass());
    	serviceIntent.putExtra("original_intent", intent);
    	context.startService(serviceIntent);
    }
    /*
     * Przesaniamy t metod, aby powrci do 
     * obiektu "klasy", nalecego do nietrwaej 
     * usugi.
     */
    public abstract Class getLRSClass();
}

