package com.androidbook.preferences.sample;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.PreferenceActivity;

/*
 *  W niniejszym przykadzie prezentujemy dwie koncepcje:
 *      - dynamicznego definiowania tekstu wejciowego oraz wejciowych wartoci,
 *      - dynamicznych aktualizacji tekstu podsumowania preferencji
 *  
 *  Dla uproszczenia wprowadzilimy tu wartoci statyczne, ktrych nie pobieramy
 *  z bazy danych, rwnie dobrze jednak moemy pobiera tekst i
 *  wartoci z dowolnego miejsca. Pamitajmy, e wybrana przez nas
 *  warto preferencji bdzie przechowywana w pliku preferencji, znajdujcym si
 *  na urzdzeniu, zatem jakiekolwiek dane zostan zachowane przez uytkownika, musz posiada one
 *  wyglda preferencji, nawet jeli wartoci pozostaych preferencji ulegy w jaki sposb zmianie.
 *  
 *  Drug rzecz, na jak naley zwrci uwag, jest moliwo usunicia metody OnSharedPreferenceChangeListener
 *  przez proces oczyszczania pamici, chyba e znajduje si do niej solidne odniesienie.
 *  W naszym przypadku korzystamy z samej aktywnoci preferencji. Nie stosujmy
 *  anonimowej, wewntrznej klasy do utworzenia obiektu nasuchujcego; jest to nieskuteczne rozwizanie.
 *  Wicej szczegw znajdziemy pod adresem:
 *  http://stackoverflow.com/questions/2542938/sharedpreferences-onsharedpreferencechangelistener-not-being-called-consistently/
 */

public class FlightPreferenceActivity extends PreferenceActivity implements OnSharedPreferenceChangeListener
{
	ListPreference listpref;
    public final static String[] optionText = getOptionText();
    public final static String[] optionValues = getOptionValues();

    static String[] getOptionText() {
    	return new String[] {"Jedzenie", "Poczekalnia", "Program Frequent Flier"};
    }

    static String[] getOptionValues() {
    	return new String[] {"0", "1", "2"};
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        addPreferencesFromResource(R.xml.flightoptions);
        listpref = (ListPreference)findPreference("selected_flight_sort_option");

        listpref.setEntryValues(optionValues);
        listpref.setEntries(optionText);
    }

    @Override
    protected void onResume() {
    	super.onResume();
    	getPreferenceScreen().getSharedPreferences()
            .registerOnSharedPreferenceChangeListener(this);
    	setSummary();
    }

    @Override
    protected void onPause() {
    	super.onPause();
    	getPreferenceScreen().getSharedPreferences()
           .unregisterOnSharedPreferenceChangeListener(this);
    }

	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences,
			String key) {
		if("selected_flight_sort_option".equals(key)) {
			setSummary();
		}
	}

	private void setSummary() {
		listpref.setSummary(optionText[Integer.valueOf(listpref.getValue())]);
	}
}
