# UWAGA: Ten przyklad nie zostal zaprojektowany, by dzialac samodzielnie.
#
# Modul Heap::Elem mozna sciagnac z http://www.perl.com/CPAN/modules/by-module/Heap.

package mapa_drog;

use Heap::Elem;

@ISA = qw(Heap::Elem);

# new - tworzy nowy obiekt mapy drog, aby mozna bylo wyznaczyc 
#     droge z poczatkowego do koncowego wezla. 
#
# $droga = mapa_drog->new( $startowe_miasto, $docelowe_miasto );
sub new {
    my $klasa = shift;
    $klasa    = ref($klasa) || $klasa;
    my $start = shift;
    my $koniec   = shift;

    return $klasa->SUPER::new(
        cur          => $start,
        end          => $koniec,
        koszt_do_tej_pory  => 0,
        droga_do_tej_pory => [$start],
    );
}

# cmp - porownuje dwie drogi na mapie.
#
# $cmp = $wezel1->cmp($wezel2);
sub cmp {
    my $nasza  = shift;
    my $inna = shift;

    return $nasza->{koszt_do_tej_pory} <=> $inna->{koszt_do_tej_pory};
}

# to_odpowiedz - konczy te droge, gdy dotrzemy do celu
#
# $boolean = $droga->to_odpowiedz;
sub to_odpowiedz {
    my $nasza = shift;
    return $nasza->{cur} eq $nasza->{end};
}

# przygotuj_ruchy - przygotowuje sie do przegladu waznych drog.
#
# $droga->przygotuj_ruchy;
sub przygotuj_ruchy {
    my $nasza = shift;
    $nasza->{edge} = -1;
}

# nastepny_ruch - znajduje nastepna sensowna droge.
#
# $move = $droga->nastepny_ruch;
sub nastepny_ruch {
    my $nasza = shift;
    return $nasza->{cur}->edge( ++$nasza->{edge} );
}

# wykonaj_ruch - trworzy nowy obiekt drogi przedluzajacy
#     obecna droge, by dotrzec do kolejnego miejsca.
#
# $droga_nowa = $droga->wykonaj_ruch( $move );
sub wykonaj_ruch {
    my $nasza = shift;
    my $krawedz = shift;
    my $nastepna = $krawedz->dest;
    my $koszt = $nasza->{koszt_do_tej_pory} + $krawedz->cost;

    return $nasza->SUPER::new(
        cur          => $nastepna,
        end          => $nasza->{end},
        koszt_do_tej_pory  => $koszt,
        droga_do_tej_pory => [ @{$nasza->{droga_do_tej_pory}}, $krawedz, $nastepna ],
    );
}
