#!/usr/bin/perl

use kolko_i_krzyzyk;        # zdefiniowany wczesniej w tym rozdziale

# wyczerpujaca analiza gry w kolko i krzyzyk z tablica transpozycji
sub ttt_wyczerpujaca_tablica {

    my $gra = kolko_i_krzyzyk->new( );

    my $odpowiedz = ttt_analiza_z_tablica( $gra );
    if ( $odpowiedz > 0 ) {
        print "Gracz 1 powinien wygrac\n";
    } elsif ( $odpowiedz < 0 ) {
        print "Gracz 2 powinien wygrac\n";
    } else {
        print "Remis\n";
    }
}

@pamiec_podreczna = ( );

# $odpowiedz = ttt_analiza_z_tablica( $gra )
#    Ustalamy, czy wygra drugi gracz.  Jesli nie, trzeba
#     wyprobowac dla niego wszystkie dostepne ruchy (z $dostep).
sub ttt_analiza_z_tablica {
    my $gra = shift;
    my $ruch = shift;

    # Wyliczamy id - indeks biezacej pozycji.
    #    Traktujemy plansze jako 9-cyfrowa liczbe o podstawie 3. Pole

    #    zawiera 0 jesli jest puste, 1 lub 2 jesli zostalo zajete
    #    przez jednego z graczy.
    if( ! defined $ruch ) {
        # Pusta plansza.
        $gra->{id} = 0;
    } else {
        # Ruch jest testowany, dodajemy jego wartosc do tego  
        # id poczatkowej pozycji.
        my $id = $gra->{id} + ($gra->{turn}+1)*(3**$ruch);
        if( defined( my $wynik = $pamiec[$id] ) ) {
            # Ta pozycja byla juz analizowana.
            return -1 if $wynik < 0;
            return 0;
        }
        my $poprzgra = $gra;
        # Nowa pozycja - analizujemy.
        $gra = $gra->wykonaj_ruch( $ruch );
        $gra->{id} = $id;
    }

    unless ( defined $gra->przygotuj_ruchy ) {
        # Nie ma zadnego ruchu.  Albo ktorys z graczy wygral,
        # albo jest remis.
        my $wynik = $gra->oceniaj;
        $pamiec[$gra->{id}] = $wynik;
        return -1 if $wynik < 0;
        return 0;
    }

    # Znajdz wynik wszystkich mozliwych ruchow.
    my $najlepsza_ocena = -1;

    while ( defined( $ruch = $gra->nastepny_ruch ) ) {
        # Niech ruch daje ujemny wynik
        #   - to co jest dobre dla przeciwnika, jest zle dla nas.
        my $ten_wynik = - ttt_analiza_z_tablica( $gra, $ruch );

        # oceniaj
        $najlepsza_ocena = $ten_wynik if $ten_wynik > $najlepsza_ocena;
    }

    $pamiec[$gra->{id}] = $najlepsza_ocena;
    return $najlepsza_ocena;
}

&ttt_wyczerpujaca_tablica();
