#!/usr/bin/perl

sub dzielenie {
    my ( $dzielenie, $pierwszy, $ostatni ) = @_;

    my $i = $pierwszy;
    my $j = $ostatni - 1;
    my $nasza_os = $dzielenie->[ $ostatni ];

 SKAN: {
        do {
            # $pierwszy <= $i <= $j <= $ostatni - 1
            # Punkt 1.

            # Przenosimy $i tak daleko, jak sie da.
            while ( $dzielenie->[ $i ] le $nasza_os ) {  
                $i++;
                last SKAN if $j < $i;
            }

            # Przenosimy $j tak daleko, jak sie da.
            while ( $dzielenie->[ $j ] ge $nasza_os ) {
                $j--;
                last SKAN if $j < $i;
            }

            # $i i $j nie spotykaja sie, wiec zamieniamy obie miejscami 
            @$dzielenie[ $j, $i ] = @$dzielenie[ $i, $j ];
        } while ( --$j >= ++$i );
    }
    # $pierwszy - 1 <= $j < $i <= $ostatni
    # Punkt 2.

    # Zamieniamy nasza os z pierwszym wiekszym elementem (jesli taki jest).
    if ( $i < $ostatni ) {
        @$dzielenie[ $ostatni, $i ] = @$dzielenie[ $i, $ostatni ];
        ++$i;
    }

    # Punkt 3.

    return ( $i, $j );   # Nowe granice wykluczaja srodek.
}

sub quicksort_iteracyjny {
    my ( $tablica, $pierwszy, $ostatni ) = @_;
    my @stos = ( $pierwszy, $ostatni );

    do {
        if ( $ostatni > $pierwszy ) {
            my ( $ostatni_z_pierwszych, $pierwszy_z_ostatnich ) =
                dzielenie $tablica, $pierwszy, $ostatni;

            # Najpierw wiekszy.
            if ( $pierwszy_z_ostatnich - $pierwszy > $ostatni - $ostatni_z_pierwszych ) {
                push @stos, $pierwszy, $pierwszy_z_ostatnich;
                $pierwszy = $ostatni_z_pierwszych;
            } else {
                push @stos, $ostatni_z_pierwszych, $ostatni;
                $ostatni = $pierwszy_z_ostatnich;
            }
        } else { 
            ( $pierwszy, $ostatni ) = splice @stos, -2, 2;  # Podwojne pop.
        }
    } while @stos;
}

sub quicksort_iter {
    quicksort_iteracyjny $_[0], 0, $#{ $_[0] };
}

@tablica = qw(To jest test awaryjnego systemu sortowania.);

quicksort_iter( \@tablica );

print "@tablica\n";
