sub literal    ($);
sub zwracanie  ($;$);
sub wyrazenie  ();
sub bledy      ($);
sub analiza    ();

my $zwracanie;  # Akumulowanie zwracanych danych.
my $bledy; # Komunikat o bledzie.

analiza;     # Wykonaj analize.

exit 0;    # Zakoncz.

sub literal ($) {
    my $lit = $_[0];    # Literalny lancuch do analizy.
    return s/^\s*\Q$lit\E\s*//;
}

sub zwracanie ($;$) { # Przetrawianie danych i zwracanie wynikow.
    unless ( $bledy ) {
        if ( @_ == 2 ) {
            my ( $wejscie, $wyjscie ) = ( literal( $_[0] ), $_[1] );
            $zwracanie .= $wyjscie if $wejscie;
            return $wejscie;
        } else {
            $zwracanie .= $_[0]; # Tylko zwracane $wyjscie.
        }
    }
}

sub wyrazenie () {
    do {
        do {
            if ( literal '(' ) {
                zwracanie '( ';
                wyrazenie;
                bledy 'brak nawiasu: )', return unless literal ')';
                zwracanie ' )';
            } elsif ( literal 'not' ) {
                bledy 'pusta negacja', return if $_ eq '';
                zwracanie '! ';
                wyrazenie;
            } else {
                if ( s/^\s*"(.+?)"\s*// || s/^\s*([^\s\)]+)\s*// ) {
                    my $slowo = $1;
                    if ( $slowo =~ /^(not|and|or)$/ ) {
                        bledy "slowo '$slowo' mie moze byc poszukiwanym slowem", return;
                    } else {
                        zwracanie "/$slowo/i";
                    }
         }
            } 
        } while zwracanie 'and', ' && ';
    } while zwracanie 'or', ' || ';
}

sub bledy ($) {
    my $komunikat = $_[0];
    $bledy = "$komunikat: $_" if $bledy eq '';
}

sub analiza () {
    while ( <STDIN> ) {
        chomp;
        $zwracanie = $bledy = '';
        wyrazenie;
        bledy 'nieprawidlowe dane' if $_ ne '';
        if ( $bledy eq '' ) {
            print "$zwracanie\n";
        } else {
            warn "analiza bledow: $bledy\n";
        }
    }
}
