#!/usr/bin/perl

# Patrz tez procedura przeszukiwanie_binarne() z Rozdzialu 1.
# $indeks = binarny_lancuch( \@tablica, $szukany )
#        @tablica zawiera posortowane lancuchy
#    na koniec,
#        albo (jesli element byl w tablicy):
#           # $indeks jest elementem
#           $tablica[$indeks] eq $szukany
#        lub (jesli elementu nie bylo w tablicy):
#           # $indeks jest pozycja, gdzie element nalezy wstawic
#           $indeks == @tablica or $tablica[$indeks] gt $szukany
#           splice( @tablica, $indeks, 0, $szukany ) wstawi go 
#               na miejsce niezaleznie od przypadku
#
sub binarny_lancuch {
     my ($tablica, $szukany) = @_;

     # $pocz jest pierwszym elementem, ktory nie jest za maly;
     # $koniec jest pierwszym elementem, ktory nie jest za duzy
     #
     my ( $pocz, $koniec ) = ( 0, scalar(@$tablica) );

     # Sprawdzaj tak dlugo, jak dlugo moga byc pasujace elementy.
     #
     while ( $pocz < $koniec ) {
         # Sprawdzamy srodkowy element.

         use integer;
         my $biez = ($pocz+$koniec)/2;
         if ($tablica->[$biez] lt $szukany) {
	     $pocz  = $biez + 1;                     # za maly, sprawdz wyzszy
	 } else {
	     $koniec = $biez;                         # nie za maly, sprawdz nizszy
	 } 
     }
     return $pocz;
}

my $slowo = "ciezaru";

@slowa_kluczowe = qw(Prawie trzecia czesc niestatystycznych wynikow, ktore obserwowal na swojej kostce
	       byla efektem wplywu nierownomiernie rozlozonego ciezaru na wynik rzutu.);

print "Indeks slowa w tablicy \@slowa_kluczowe jest: ", binarny_lancuch( \@slowa_kluczowe, $slowo ), "\n";



