#!/usr/bin/perl

sub insertion_sort {
    my $tablica = shift;

    my $i;      # Poczatkowy indeks dla elementu minimum.
    my $j;      # Biezacy indeks dla operacji odszukiwania minimum.

    for ( $i = 0; $i < $#$tablica; $i++ ) {
        my $m = $i;               # Koncowy indeks dla elementu minimum.
        my $x = $tablica->[ $m ]; # Wartosc minimum.

        for ( $j = $i + 1; $j < @$tablica; $j++ ) {
            ( $m, $x ) = ( $j, $tablica->[ $j ] ) # Aktualizacja minimum.
              if $tablica->[ $j ] lt $x;
        }

        # Podwojna operacja splice po prostu przenosi $m-ty element 
        # na $i-ty element. Uwaga: koszt splice to O(N), nie O(1).
        # Tak dlugo, jak dlugo rozwazamy zlozonosc czasowa algorytmu,
        # nie ma roznicy, czy przenosimy blok tablicy uzywajac 
        # petli, czy uzywajac splice(). Nadal funkcja, splice()
        # jest szybsza niz przenoszenie bloku element po elemencie.
        splice @$tablica, $i, 0, splice @$tablica, $m, 1 if $m > $i;
    }
}

@tablica = qw(jesli szukasz dobrego algorytmu zadwon do abigail 104-5876);

insertion_sort(\@tablica);

print "@tablica\n";