#!/usr/bin/perl

BEGIN { do "huffman" }  # Wykonujemy program "huffman" z biezacego katalogu

#####################################################################
#
# Budujemy optymalne drzewo kodowania dla tekstu. (Zazwyczaj nie uzywamy
# do tego calego tekstu, tylko tekstu, ktory ma podobny rozklad znakow
# 

my $tekst = <<EOT;
bylo smaszno a jaszmije
smukiwijne na zegawniku wezaly
peliczaple staly smutcholijne
i zblakinie rykoswistaly
EOT

my %wagi;

foreach $ch (split //, $tekst) {
    ++$wagi{$ch};
}

my $drzewo_kodowania = zbuduj_hash_z_drzewa \%wagi;



#####################################################################
#
# Pakowanie
#
# dostarczamy "symboli" znak po znaku:

my @strumien;

sub pobierz_strumien {
    return shift @strumien;
}

# zbieramy bity "bity" jako lancuchy ze znakow 0/1

my $zwracanie = '';

sub zwroc_bit {
    $zwracanie .= substr "01", $_[0], 1;
}

# wyliczamy tablice asocjacyjna odpowiadajaca drzewu

my %hash_drzewa;
huff_hash $drzewo_kodowania, \%hash_drzewa;

# kodujemy

@strumien = split //, $tekst;

huff_kodowanie \%hash_drzewa, \&pobierz_strumien, \&zwroc_bit;





#####################################################################
#
# Rozpakowywanie
#
# Wyjmujemy "bity" jeden po drugim:

my @bity = split //, $zwracanie;

my %bit = ( '0'=>0, '1'=>1 );

sub pobierz_bit {
    return $bit{shift @bity};
}

# zbieramy tokeny do lancucha

my $odkodowanie = '';

sub zwroc_strumien {
    $odkodowanie .= $_[0];
}

# odkodowujemy

huff_dekodowanie $drzewo_kodowania, \&pobierz_bit, \&zwroc_strumien;

print "Oryginalny tekst: -----\n$tekst----- ", length($tekst), " znakow\n",
    "\nZakodowant tekst: -----\n$zwracanie\n----- ", length($zwracanie), " bitow = ",
	int((length($zwracanie)+7)/8), " znakow\n",
    "\nKoncowy tekst: -----\n$odkodowanie----- ", length($odkodowanie), " znakow\n";
