#!/usr/bin/perl -w

use integer;
sub porzadkowanie;

sub heapsort {
    my $tablica = shift;

    foreach ( my $indeks = 1 + @$tablica / 2; $indeks--; ) {
        porzadkowanie $tablica, $indeks;
    }

    foreach ( my $ostatni = @$tablica; --$ostatni; ) {
        @{ $tablica }[ 0, $ostatni ] = @{ $tablica }[ $ostatni, 0 ];
        porzadkowanie $tablica, 0, $ostatni;
    }
}

sub porzadkowanie {
    my ($tablica, $indeks, $ostatni) = @_;

    $ostatni = @$tablica unless defined $ostatni;

    my $zamiana = $indeks;
    my $gora = $indeks * 2 + 1;

    foreach ( my $try = $indeks * 2;
                 $try < $ostatni && $try <= $gora;
                 $try ++ ) {
        $zamiana = $try if $tablica->[ $try ] gt $tablica->[ $zamiana ];
    }

    unless ( $zamiana == $indeks ) {
        # Sterta jest nieuporzadkowana, trzeba ja uporzadkowac.
        @{ $tablica }[ $zamiana, $indeks ] = @{ $tablica }[ $indeks, $zamiana ];
        porzadkowanie $tablica, $zamiana, $ostatni;
    }
}


@tablica = qw(Mam holograficzna tabliczke czekolady.  Naprawde.  Nie powinienem
	jej jesc bo jest wyjatkowa. Ale jestem naprawde glodny i sprawdzam te
	przyklady juz caly dzien.  Mysle ze nalezy mi sie jakas nagroda.);

heapsort( \@tablica );

print "@tablica\n";
