#!/usr/bin/perl

sub elementy_na_liczby {
    my ( @nazwy,   $nazwa );
    my ( %liczby, $liczba );

    $liczba = 0;
    while ( my $zbior = shift @_ ) {
        while ( defined ( $nazwa = each %$zbior ) ) {
            unless ( exists $liczby{ $nazwa } ) {
        $liczby{ $nazwa   } = $liczba;
        $nazwy  [ $liczba ] = $nazwa;
        $liczba++;
            }
        }
    }

    return ( $liczba, \%liczby, \@nazwy );
}

sub tablica_asoc_na_wektor_bitow {
    my ( $hash, $liczby ) = @_;
    my ( $nazwa, $wektor );

    # Inicjujemy $wektor bitami zerowymi.
    #
    $wektor = '';

    while ( defined ($nazwa = each %{ $hash })) {
        vec( $wektor, $liczby->{ $nazwa }, 1 ) = 1;
    }

    return $wektor;
}

sub wektor_bitow_na_tablice_asoc {
    my ( $wektor, $nazwy ) = @_;
    my ( $liczba, %zbior_tablica_asoc );

    foreach $liczba ( 0..$#{ $nazwy }) {
        $zbior_tablica_asoc{ $nazwy->[ $liczba ] } = undef
            if vec( $wektor, $liczba, 1 );
    }

    return \%zbior_tablica_asoc;
}

@Psowate     { qw(pies wilk)      } = ( );
@Udomowione{ qw(pies kot kon) } = ( );

( $size, $liczby, $nazwy ) =
        elementy_na_liczby( \%Psowate, \%Udomowione );

$Psowate      = tablica_asoc_na_wektor_bitow( \%Psowate, $liczby );
$Udomowione = tablica_asoc_na_wektor_bitow( \%Udomowione, $liczby );

$suma_zbiorow        = $Psowate | $Udomowione; # Binarne OR.

$czesc_wspolna = $Psowate & $Udomowione; # Binarne AND.

print "suma zbiorow = ",
      "@{ [ keys %{ wektor_bitow_na_tablice_asoc( $suma_zbiorow, $nazwy ) } ] }\n";

print "czesc wspolna = ",
      "@{ [ keys %{ wektor_bitow_na_tablice_asoc( $czesc_wspolna, $nazwy ) } ] }\n";
