#!/usr/bin/perl

# Modul ten mozna pobrac z sieci CPAN 
# http://www.perl.com/CPAN/modules/by-module.
use Bit::Vector;

# Tworzymy wektor bitow o rozmiarze 8000.

$wektor = Bit::Vector->new( 8000 );

# Definiujemy bity 1000..2000.

$wektor->Interval_Fill( 1000, 2000 );

# Czyscimy bity 1100..1200.

$wektor->Interval_Empty( 1100, 1200 );

# Wylaczamy bit 123, wlaczamy bit 345 i przelaczamy bit 456.

$wektor->Bit_Off ( 123 );
$wektor->Bit_On  ( 345 );
$wektor->bit_flip( 456 );

# Test bitow.

print "bit 123 jest wlaczony\n" if $wektor->bit_test( 123 );

# Teraz zapelniamy bity 3000..6199 wektora $wektor szesnastkowymi kodami ASCII.
# Najpierw tworzymy zbior o odpowiednim rozmiarze...

$wypelnienie = Bit::Vector->new( 8000 );

# zapelniamy go 8000-znakowym lancuchem...

$wypelnienie->from_string( "deadbeef" x 100 );

# i przesuwamy go w lewo o 3000 bitow for aby trafil na
# planowana pozycje 3000.

$wypelnienie->Move_Left( 3000 );

# na koniec wykonujemy operacje OR miedzy bitami $wypelnienie i $wektor.

$wektor |= $wypelnienie;

# Zwracamy wektor w "lancuchowym" (szesnastkowym) formacie.

print $wektor->to_String, "\n";
