import matplotlib.pyplot as plt
import numpy as np

from keras.models import Sequential
from keras.layers import LSTM, Dense, Activation
from keras.optimizers import Adam

from sklearn.preprocessing import MinMaxScaler


# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)

# Zestaw danych jest dostępna pod adresem: https://datamarket.com/data/set/22ti/zuerich-monthly-sunspot-numbers-1749-1983#!ds=22ti&display=line﻿
dataset_filename = '<TWOJA_ŚCIEŻKA_DO_PLIKU>\dataset.csv'

n_samples = 2820
data = np.zeros(shape=(n_samples, ), dtype=np.float32)

sequence_length = 15


if __name__ == '__main__':
    # Wczytuje zestaw danych
    with open(dataset_filename, 'r') as f:
        lines = f.readlines()

    for i, line in enumerate(lines):
        if i == 0:
            continue

        if i == n_samples + 1:
            break

        _, value = line.split(',')
        data[i - 1] = float(value)

    # Skaluje zestaw danych w zakresie od -1 do 1
    mmscaler = MinMaxScaler((-1.0, 1.0))
    data = mmscaler.fit_transform(data.reshape(-1, 1))

    # Ukazuje zestaw danych
    fig, ax = plt.subplots(figsize=(20, 10))

    ax.plot(data)
    ax.grid()
    ax.set_xlabel('Takty')
    ax.set_ylabel('Liczba plam słonecznych w danym miesiącu')
    plt.show()

    # Tworzy zbiory uczący i testowy (z zaokrągleniem do 2800 przykładów)
    X_ts = np.zeros(shape=(n_samples - sequence_length, sequence_length, 1), dtype=np.float32)
    Y_ts = np.zeros(shape=(n_samples - sequence_length, 1), dtype=np.float32)

    for i in range(0, data.shape[0] - sequence_length):
        X_ts[i] = data[i:i + sequence_length]
        Y_ts[i] = data[i + sequence_length]

    X_ts_train = X_ts[0:2300, :]
    Y_ts_train = Y_ts[0:2300]

    X_ts_test = X_ts[2300:2800, :]
    Y_ts_test = Y_ts[2300:2800]

    # Tworzy model
    model = Sequential()

    model.add(LSTM(4, stateful=True, batch_input_shape=(20, sequence_length, 1)))

    model.add(Dense(1))
    model.add(Activation('tanh'))

    # Kompiluje model
    model.compile(optimizer=Adam(lr=0.001, decay=0.0001),
                  loss='mse',
                  metrics=['mse'])

    # Uczy model
    model.fit(X_ts_train, Y_ts_train,
              batch_size=20,
              epochs=100,
              shuffle=False,
              validation_data=(X_ts_test, Y_ts_test))

    # Ukazuje rezultaty
    fig, ax = plt.subplots(figsize=(20, 10))

    ax.plot(Y_ts_test, label='Wartości rzeczywiste')
    ax.plot(model.predict(X_ts_test, batch_size=20), label='Wartości przewidywane')
    ax.grid()
    ax.set_xlabel('Takty')
    ax.set_ylabel('Liczba plam słonecznych w danym miesiącu')
    ax.legend()
    plt.show()





