import matplotlib.pyplot as plt
import numpy as np

# Aby zainstalować bibliotekę Scikit-Fuzzy (jeśli nie jest domyślnie zainstalowana): pip install -U scikit-fuzzy
# Dalsze instrukcje znajdziesz pod adresem: https://pythonhosted.org/scikit-fuzzy/
from skfuzzy.cluster import cmeans, cmeans_predict

from sklearn.datasets import load_digits


# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Wczytuje zestaw danych
    digits = load_digits()
    X_train = digits['data'] / np.max(digits['data'])

    # Realizuje algorytm rozmytych c-średnich
    fc, W, _, _, _, _, pc = cmeans(X_train.T, c=10, m=1.25, error=1e-6, maxiter=10000, seed=1000)

    print('Znormalizowany indeks Dunna: {}'.format(pc))

    # Tworzy wykres centroidów
    fig, ax = plt.subplots(1, 10, figsize=(10, 10))

    for i in range(10):
        c = fc[i]
        ax[i].matshow(c.reshape(8, 8) * 255.0, cmap='gray')
        ax[i].set_xticks([])
        ax[i].set_yticks([])

    plt.show()

    # Stopnie przynależności przykładu reprezentującego cyfrę '7'
    print('Stopnie przynależności: {}'.format(W[:, 7]))

    fig, ax = plt.subplots(figsize=(15, 8))

    ax.plot(np.arange(10), W[:, 7])
    ax.set_xlabel('Indeks skupienia')
    ax.set_ylabel('Przynależność rozmyta')
    ax.grid()

    plt.show()

    # Uzyskuje prognozę
    new_sample = np.expand_dims(X_train[7], axis=1)
    Wn, _, _, _, _, _ = cmeans_predict(new_sample, cntr_trained=fc, m=1.25, error=1e-6, maxiter=10000, seed=1000)

    print('Stopnie przynależności: {}'.format(Wn.T))

