import numpy as np

from sklearn.datasets import load_iris
from sklearn.linear_model import LogisticRegression
from sklearn.model_selection import cross_val_score, LeavePOut


# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Wczytuje zestaw danych
    data = load_iris()

    p = 3
    lr = LogisticRegression()

    # Przeprowadza sprawdzian krzyżowy metodą Leave-P-Out
    lpo_scores = cross_val_score(lr, data['data'], data['target'], cv=LeavePOut(p))
    print('Wyniki metody LPO (100): {}'.format(lpo_scores[0:100]))
    print('Uśredniony wynik metody LPO: {}'.format(lpo_scores.mean()))
