import copy
import random
import math

# Ustawianie identyfikatorów dla minimum i maksimum oraz stałych symulujących nieskończoność.
MIN = -1
MAX = 1
INFINITY_POSITIVE = math.inf
INFINITY_NEGATIVE = -math.inf


# Ta klasa reprezentuje ruch i przechowuje wartość ruchu.
class Move:

    def __init__(self, move=0, value=0):
        self.move = move
        self.value = value


# Wybór ruchu w zależności od gry i głębokości przeszukiwania.
def choose_move(connect, depth):
    print('Trwa analiza...')
    move_result = False
    # Szukanie ruchu do czasu znalezienia poprawnego posunięcia.
    while move_result is False:
        move_result = minmax(connect, depth, MAX, 0).move
    return move_result


# Przeszukiwanie za pomocą algorytmu min-max na podstawie gry, głębokości przeszukiwania,
# identyfikatora gracza i ruchu domyślnego.
def minmax(connect, depth, min_or_max, move):
    current_score = connect.get_score_for_ai()
    current_is_board_full = connect.is_board_full()
    # Zwraca ruch domyślny, jeśli poszukiwania nie mają sensu.
    if current_score != 0 or current_is_board_full or depth == 0:
        return Move(move, current_score)

    best_score = INFINITY_NEGATIVE * min_or_max
    best_max_move = -1
    # Pobieranie możliwych ruchów na podstawie wielkości planszy.
    moves = random.sample(range(0, connect.board_size_y + 1), connect.board_size_x)
    # Sprawdzanie każdego ruchu.
    for slot in moves:
        neighbor = copy.deepcopy(connect)
        move_outcome = neighbor.play_move(slot)
        if move_outcome:
            # Rekurencyjne wywoływanie funkcji minmax dla następnego stanu po wykonaniu ruchu.
            best = minmax(neighbor, depth - 1, min_or_max * -1, slot)
            # Aktualizowanie najlepszego wyniku i najlepszego ruchu.
            if (min_or_max == MAX and best.value > best_score) or (min_or_max == MIN and best.value < best_score):
                best_score = best.value
                best_max_move = best.move
    return Move(best_max_move, best_score)
