from sklearn import tree
from sklearn import metrics
import sys
sys.path.append('../')
from ml_data_preparation import Data


# Kodowanie tekstowych wartości cech "szlif", "barwa" i "czystość" jako wartości całkowitoliczbowych.
encoding_categories = {'szlif': {'Zadowalający': 1, 'Dobry': 1, 'Bardzo dobry': 2, 'Premium': 2, 'Doskonały': 2},
                       'barwa': {'D': 7, 'E': 6, 'F': 5, 'G': 4, 'H': 3, 'I': 2, 'J': 1},
                       'czystość': {'FL': 11, 'IF': 10, 'VVS1': 9, 'VVS2': 8, 'VS1': 7, 'VS2': 6, 'SI1': 5, 'SI2': 4, 'I1': 3, 'I2': 2, 'I3': 1}}

# "numer","karaty","szlif","barwa","czystość","głębokość","tafla","cena","wymiar x","wymiar y","wymiar z"
data = Data('../diamonds.csv', ['numer', 'barwa', 'czystość', 'głębokość', 'tafla', 'wymiar x', 'wymiar y', 'wymiar z'], 'szlif', encoding_categories)
print(data.X_train.head())
# clf = ensemble.RandomForestClassifier()
clf = tree.DecisionTreeClassifier()
clf = clf.fit(data.X_train, data.y_train)
prediction = clf.predict(data.X_test)
print("Trafność: ", metrics.accuracy_score(prediction, data.y_test))
