import itertools
import csv
import math
import time

start = time.time()

# Wczytywanie atrakcji odległości między atrakcjami z pliku CSV.
attraction_count = 48
attraction_data_file = 'attractions-' + str(attraction_count) + '.csv'
attraction_distances = []
with open(attraction_data_file) as file:
    reader = csv.reader(file, quoting=csv.QUOTE_NONNUMERIC)
    for row in reader:
        attraction_distances.append(row)
print('Zakończono wczytywanie odległości między atrakcjami')

# Inicjowanie najlepszej odległości i najlepszej permutacji.
best_distance = math.inf
best_permutation = None
# Określanie na podstawie odległości wyników dla każdej permutacji, aby znaleźć najlepszą z nich.
for attraction_permutation in itertools.permutations(range(0, attraction_count)):
    last_attraction = attraction_permutation[0]
    total_distance = 0
    for attraction_index in range(1, len(attraction_permutation)):
        total_distance += attraction_distances[last_attraction][attraction_permutation[attraction_index]]
        last_attraction = attraction_permutation[attraction_index]
    if total_distance < best_distance:
        best_distance = total_distance
        best_permutation = attraction_permutation
    print('Aktualna najlepsza permutacja: ', best_permutation)
    print('Aktualna najlepsza odległość: ', best_distance)

print('Najlepsza permutacja: ', best_permutation)
print('Najlepsza odległość: ', best_distance)

end = time.time()
print('Czas obliczania: ', end - start)
