import numpy as np


# Sztuczne sieci neuronowe
# Przyjrzyj się etapom i różnym operacjom z algorytmu propagacji wstecznej.

# Etap A. Przygotowanie
# 1.	Zdefiniuj architekturę sieci ANN. Ten krok wymaga zdefiniowania węzłów wejściowych, węzłów wyjściowych, 
#       liczby warstw ukrytych, liczby neuronów w każdej warstwie ukrytej, używanej funkcji aktywacji itd.
# 2.	Zainicjuj wagi w sieci ANN. Wagi w sieci ANN trzeba zainicjować jakąś wartością. Można zastosować tu różne podejścia. 
#       Najważniejszą zasadą jest stałe dostosowywanie wag wraz z uczeniem się sieci ANN na podstawie obserwacji treningowych.

# Etap B. Propagacja w przód. Ten proces przebiega tak samo jak przy samym korzystaniu z sieci. Wykonywane są te same obliczenia. 
# Jednak w trakcie uczenia sieci prognozowane dane wyjściowe są porównywane z rzeczywistą klasą każdej obserwacji ze zbioru 
# treningowego.

# Etap C. Uczenie
# 1.	Oblicz koszt. Po propagacji w przód jako koszt przyjmowana jest różnica między prognozowanymi danymi wyjściowymi a 
#       rzeczywistą klasą obserwacji ze zbioru treningowego. Koszt określa, jak dobrze sieć ANN radzi sobie z prognozowaniem 
#       klas obserwacji.
# 2.	Zaktualizuj wagi w sieci ANN. Wagi w sieci ANN to jedyne wartości, jakie mogą być aktualizowane przez samą sieć. 
#       Architektura i konfiguracja zdefiniowane na etapie A nie zmieniają się w procesie uczenia sieci. Wagi kodują 
#       inteligencję sieci i mogą być zwiększane lub zmniejszane, co wpływa na „siłę” danych wejściowych. 
# 3.	Zdefiniuj warunek zakończenia pracy. Proces uczenia nie może trwać w nieskończoność. Podobnie jak w wielu innych 
#       algorytmach omawianych w tej książce trzeba ustalić sensowny warunek zakończenia pracy. Jeśli zbiór danych jest 
#       duży, możesz zdecydować, że w procesie uczenia sieci ANN użyjesz 500 obserwacji ze zbioru treningowego i przeprowadzisz 
#       1000 iteracji. Oznacza to, że 500 obserwacji zostanie 1000 razy przekazanych do sieci, a po każdej iteracji algorytm 
#       dostosuje wagi.


# Skalowanie zbioru danych do wartości z przedziału od 0 do 1 metodą min-max.
def scale_dataset(dataset, feature_count, feature_min, feature_max):
    scaled_data = []
    for data in dataset:
        example = []
        for i in range(0, feature_count):
            example.append(scale_data_feature(data[i], feature_min[i], feature_max[i]))
        scaled_data.append(example)
    return np.array(scaled_data)


# Skalowanie cech ze zbioru danych do wartości z przedziału od 0 do 1 metodą min-max.
def scale_data_feature(data, feature_min, feature_max):
    return (data - feature_min) / (feature_max - feature_min)


# Jako funkcja aktywacji używana jest funkcja sigmoidalna.
# np.exp reprezentuje stałą matematyczną zwaną liczbą Eulera i równą w przybliżeniu 2.71828.
def sigmoid(x):
    return 1 / (1 + np.exp(-x))


# Pochodna funkcji sigmoidalnej.
def sigmoid_derivative(x):
    return sigmoid(x) * (1 - sigmoid(x))


# Klasa zawierająca mechanizmy sztucznej sieci neuronowej.
class NeuralNetwork:
    def __init__(self, features, labels, hidden_node_count):
        # Zapisanie cech jako danych wejściowych dla sieci neuronowej.
        self.input = features
        # Inicjowanie losowymi wartościami wag połączeń między warstwą wejścią a warstwą ukrytą.
        self.weights_input = np.random.rand(self.input.shape[1], hidden_node_count)
        print(self.weights_input)
        # Inicjowanie wyjść węzłów ukrytych wartością None.
        self.hidden = None
        # Inicjowanie wag połączeń między warstwą ukrytą a warstwą wyjściową.
        self.weights_hidden = np.random.rand(hidden_node_count, 1)
        print(self.weights_hidden)
        # Odwzorowanie oczekiwanych danych wyjściowych na etykiety.
        self.expected_output = labels
        # Inicjowanie wartości wyjściowych zerami.
        self.output = np.zeros(self.expected_output.shape)

    def add_example(self, features, label):
        np.append(self.input, features)
        np.append(self.expected_output, label)

    # Propagacja w przód - obliczanie sum ważonych i wartości funkcji aktywacji.
    def forward_propagation(self):
        hidden_weighted_sum = np.dot(self.input, self.weights_input)
        self.hidden = sigmoid(hidden_weighted_sum)
        output_weighted_sum = np.dot(self.hidden, self.weights_hidden)
        self.output = sigmoid(output_weighted_sum)

    # Propagacja wsteczna - obliczanie kosztu i aktualizowanie wag.
    def back_propagation(self):
        cost = self.expected_output - self.output
        print('RZECZYWISTA: ')
        print(self.expected_output)
        print('PROGNOZOWANA: ')
        print(self.output)
        print('KOSZT: ')
        print(cost)
        print('UKRYTA: ')
        print(self.hidden)
        weights_hidden_update = np.dot(self.hidden.T, (2 * cost * sigmoid_derivative(self.output)))
        print('AKTUALIZACJA WAG WARSTWY UKRYTEJ:')
        print(weights_hidden_update)
        weights_input_update = np.dot(self.input.T, (np.dot(2 * cost * sigmoid_derivative(self.output), self.weights_hidden.T) * sigmoid_derivative(self.hidden)))
        print('AKTUALIZACJA WAG WARSTWY WEJŚCIOWEJ:')
        print(weights_hidden_update)

        # Aktualizowanie wag na podstawie pochodnej (nachylenia) funkcji straty.
        self.weights_hidden += weights_hidden_update
        print('WAGI WARSTWY UKRYTEJ:')
        print(weights_hidden_update)

        self.weights_input += weights_input_update
        print('WAGI WARSTWY WEJŚCIOWEJ:')
        print(weights_hidden_update)


def run_neural_network(feature_data, label_data, feature_count, features_min, features_max, hidden_node_count, epochs):
    # Skalowanie zbioru danych metodą min-max.
    scaled_feature_data = scale_dataset(feature_data, feature_count, features_min, features_max)
    # Inicjowanie sieci neuronowej przeskalowanymi danymi i węzłami warstwy ukrytej.
    nn = NeuralNetwork(scaled_feature_data, label_data, hidden_node_count)
    # Uczenie sztucznej sieci neuronowej przez wiele iteracji, używając tych samych danych treningowych.
    for epoch in range(epochs):
        nn.forward_propagation()
        nn.back_propagation()

    print('DANE WYJŚCIOWE: ')
    for r in nn.output:
        print(r)

    print('WAGI WARSTWY WEJŚCIOWEJ: ')
    print(nn.weights_input)

    print('WAGI WARSTWY UKRYTEJ: ')
    print(nn.weights_hidden)


if __name__ == '__main__':
    # Liczba cech w zbiorze danych.
    FEATURE_COUNT = 4
    # Minimalne możliwe wartości cech (szybkość, jakość drogi, widoczność, doświadczenie).
    FEATURE_MIN = [0, 0, 0, 0]
    # Maksymalne możliwe wartości cech (szybkość, jakość drogi, widoczność, doświadczenie).
    FEATURE_MAX = [120, 10, 360, 400000]
    # Liczba węzłów w warstwie ukrytej.
    HIDDEN_NODE_COUNT = 5
    # Liczba iteracji nauki sieci neuronowej.
    EPOCHS = 1500

    # Treningowy zbiór danych (szybkość, jakość drogi, widoczność, doświadczenie).
    car_collision_data = np.array([
        [65, 5,	180, 80000],
        [120, 1, 72, 110000],
        [8,	6,	288, 50000],
        [50, 2,	324, 1600],
        [25, 9,	36, 160000],
        [80, 3,	120, 6000],
        [40, 3,	360, 400000]
    ])

    # Etykiety treningowego zbioru danych (0 = bez kolizji, 1 = kolizja)
    car_collision_data_labels = np.array([
        [0],
        [1],
        [0],
        [1],
        [0],
        [1],
        [0]])

    # Uruchamianie sieci neuronowej.
    run_neural_network(car_collision_data,
                       car_collision_data_labels,
                       FEATURE_COUNT,
                       FEATURE_MIN,
                       FEATURE_MAX,
                       HIDDEN_NODE_COUNT,
                       EPOCHS)
