from collections import deque
import maze_puzzle as mp


# Funkcja znajdująca trasę za pomocą algorytmu przeszukiwania wszerz.

# Przeszukiwanie wszerz to algorytm służący do przechodzenia lub generowania drzewa. Rozpoczyna od określonego 
# węzła (korzenia) i sprawdza wszystkie węzły o danej głębokości, a potem przechodzi do następnego poziomu węzłów. 
# Oznacza to odwiedzenie wszystkich dzieci węzłów z danego poziomu przed przejściem do dzieci z następnego poziomu. 
# Ostatecznie algorytm znajduje docelowy liść.

# Algorytm przeszukiwania wszerz najlepiej jest zaimplementować za pomocą kolejki FIFO, w której przetwarzane są 
# węzły z bieżącego poziomu, a do kolejki dodawane są ich dzieci w celu ich późniejszego przetworzenia. Ta kolejność 
# przetwarzania jest w pełni zgodna z wymogami stawianymi implementacji tego algorytmu.
def run_bfs(maze_puzzle, current_point, visited_points):
    queue = deque()
    # Dołączanie bieżącego węzła do kolejki.
    queue.append(current_point)
    visited_points.append(current_point)
    # Przeszukiwanie jest kontynuowane, dopóki w kolejce znajdują się węzły.
    while queue:
        # Ustawianie następnego węzła z kolejki jako węzła bieżącego.
        current_point = queue.popleft()
        # Pobieranie sąsiadów bieżącego węzła.
        neighbors = maze_puzzle.get_neighbors(current_point)
        # Iteracyjne przetwarzanie sąsiadów bieżącego węzła.
        for neighbor in neighbors:
            # Dodawanie sąsiada do kolejki, jeśli nie został jeszcze odwiedzony.
            if not is_in_visited_points(neighbor, visited_points):
                neighbor.set_parent(current_point)
                queue.append(neighbor)
                visited_points.append(neighbor)
                # Zwracanie ścieżki do bieżącego sąsiada, jeśli jest celem.
                if maze_puzzle.get_current_point_value(neighbor) == '*':
                    return neighbor
    # Wartość zwracana, jeśli nie znaleziono ścieżki do celu.
    return 'Nie znaleziono ścieżki do celu.'


# Funkcja sprawdzająca, czy dany węzeł został już odwiedzony.
def is_in_visited_points(current_point, visited_points):
    for visited_point in visited_points:
        if current_point.x == visited_point.x and current_point.y == visited_point.y:
            return True
    return False


print('--- Przeszukiwanie wszerz ---')

# Inicjowanie obiektu typu MazePuzzle.
maze_game_main = mp.MazePuzzle()

# Uruchamianie algorytmu przeszukiwania wszerz dla zainicjowanego labiryntu.
starting_point = mp.Point(2, 2)
outcome = run_bfs(maze_game_main, starting_point, [])

# Pobieranie ścieżki znalezionej przez algorytm przeszukiwania wszerz.
bfs_path = mp.get_path(outcome)

# Wyświetlanie informacji o znalezionej ścieżce.
print('Długość ścieżki: ', len(bfs_path))
maze_game_main.overlay_points_on_map(bfs_path)
print('Koszt ścieżki: ', mp.get_path_cost(outcome))
for point in bfs_path:
    print('Punkt: ', point.x, ',', point.y)
