import numpy as np

# Perceptron
# Neuron jest podstawowym elementem mózgu i systemu nerwowego. Wcześniej opisano, że przyjmuje wiele pobudzeń wejściowych 
# z innych neuronów, przetwarza te pobudzenia i przekazuje wynik do innych powiązanych neuronów. Sieci ANN bazują na 
# perceptronach. Jest to logiczna reprezentacja jednego neuronu biologicznego.

# Cechy
# palenie, nadwaga, ćwiczenia
dataset = np.array([[0, 1, 0],
                    [0, 0, 1],
                    [1, 0, 0],
                    [1, 1, 0],
                    [1, 1, 0],
                    [1, 0, 1],
                    [0, 1, 0],
                    [1, 1, 1]])
dataset_labels = np.array([[1, 0, 0, 1, 1, 0, 0, 1]])
dataset_labels = dataset_labels.reshape(8, 1)

np.random.seed(42)
weights = np.random.rand(3, 1)
bias = 1  # np.random.rand(1)
learning_rate = 0.05


def sigmoid(x):
    return 1/(1+np.exp(-x))


def sigmoid_derivative(x):
    return sigmoid(x)*(1-sigmoid(x))


for epoch in range(10000):
    # Mnożenie wszystkich wejść przez wagi i sumowanie wyników.
    weight_and_sum_results = np.dot(dataset, weights) + bias
    # Stosowanie sigmoidalnej funkcji aktywacyjnej do wszystkich sum.
    activation_results = sigmoid(weight_and_sum_results)
    # Ustalanie wielkości błędu dla każdego wiersza danych.
    error = activation_results - dataset_labels
    # Znajdowanie nachylenia prognozowanych wyników za pomocą pochodnych.
    predicted_results_derivative = sigmoid_derivative(activation_results)
    # Znajdowanie wartości, o jaką należy dostosować wagi.
    z_delta = error * predicted_results_derivative
    # Zmiana kształtu tablicy, aby móc pracować z macierzami o spójnych kształtach.
    inputs = dataset.transpose()
    # Aktualizowanie wag metodą gradientu prostego.
    weights -= learning_rate * np.dot(inputs, z_delta)
    # Aktualizowanie tendencyjności.
    for num in z_delta:
        bias -= learning_rate * num


# Palacz z nadwagą, brak ćwiczeń.
single_point = np.array([1, 0, 0])
result = sigmoid(np.dot(single_point, weights) + bias)
print('Palacz z nadwagą, brak ćwiczeń')
print(result)

# Niepalący z nadwagą, brak ćwiczeń.
single_point = np.array([0, 1, 0])
result = sigmoid(np.dot(single_point, weights) + bias)
print('Niepalący z nadwagą, brak ćwiczeń')
print(result)

# Niepalący bez nadwagi i wykonujący ćwiczenia.
single_point = np.array([0, 0, 1])
result = sigmoid(np.dot(single_point, weights) + bias)
print('Niepalący bez nadwagi i wykonujący ćwiczenia')
print(result)
