import numpy as np
import matplotlib.pyplot as plt
import statistics

# Wielkość każdego diamentu w karatach.
carats = [0.3,
          0.41,
          0.75,
          0.91,
          1.2,
          1.31,
          1.5,
          1.74,
          1.96,
          2.21]

# Skalowanie wielkości diamentów w karatach, aby dostosować wartości do cen.
carats = [i * 1000 for i in carats]

# Cena każdego diamentu.
price = [339,
         561,
         2760,
         2763,
         2809,
         3697,
         4022,
         4677,
         6147,
         6535]

# Obliczanie średnich dla cech 'cena' i 'karaty'.
mean_X = statistics.mean(carats)
print(mean_X)
mean_Y = statistics.mean(price)
print(mean_Y)

# Ustalanie liczby obserwacji w zbiorze danych.
number_of_examples = len(carats)

# Wyświetlanie wartości x (karaty).
print('x')
for i in range(number_of_examples):
    print('{0:.0f}'.format(carats[i]))

# Wyświetlanie wartości x - średnia x.
print('x - średnia x')
for i in range(number_of_examples):
    print('{0:.0f}'.format(carats[i] - mean_X))

# Wyświetlanie wartości y - średnia y.
print('y - średnia y')
for i in range(number_of_examples):
    print('{0:.0f}'.format(price[i] - mean_Y))

# Wyświetlanie wartości x - (średnia x)^2.
print('x - (średnia x)^2')
sum_x_squared = 0
for i in range(number_of_examples):
    ans = (carats[i] - mean_X) ** 2
    sum_x_squared += ans
    print('{0:.0f}'.format(ans))
print('SUMA kwadratów: ', sum_x_squared)

# Wyświetlanie wartości (x - średnia x) * (y - średnia y).
print('(x - średnia x mean) * (y - średnia y)')
sum_multiple = 0
for i in range(number_of_examples):
    ans = (carats[i] - mean_X) * (price[i] - mean_Y)
    sum_multiple += ans
    print('{0:.0f}'.format(ans))
print('SUMA iloczynów: ', sum_multiple)

b1 = sum_multiple / sum_x_squared
print('b1: ', b1)
b0 = mean_Y - (b1 * mean_X)
print('b0: ', b0)
min_x = np.min(carats)
max_x = np.max(carats)
x = np.linspace(min_x, max_x, 10)

# Zapisywanie regresji liniowej jako y = mx + c.
y = b0 + b1 * x

# Dane testowe.
carats_test = [
    220,
    330,
    710,
    810,
    1080,
    1390,
    1500,
    1640,
    1850,
    1910
]

price_test = [
    342,
    403,
    2772,
    2789,
    2869,
    3914,
    4022,
    4849,
    5688,
    6632
]

price_test_mean = statistics.mean(price_test)
print('Średnia cen testowych: ', price_test_mean)
price_test_n = len(price_test)
print('Różnice cen testowych względem średniej:')
for i in range(price_test_n):
    print(price_test[i] - price_test_mean)

print('Suma kwadratów różnic cen testowych względem średniej:')
sum_of_price_test_difference = 0
for i in range(price_test_n):
    ans = (price_test[i] - price_test_mean) ** 2
    sum_of_price_test_difference += ans
    print(ans)
print('Suma kwadratów różnic: ', sum_of_price_test_difference)

print('Prognozowane wartości:')
for i in range(price_test_n):
    print('{0:.0f}'.format(b0 + carats_test[i] * b1))
print('Prognozowane wartości - średnia:')
for i in range(price_test_n):
    print('{0:.0f}'.format((b0 + carats_test[i] * b1) - price_test_mean))

print('(Prognozowane - średnia) do kwadratu:')
sum_of_price_test_prediction_difference = 0
for i in range(price_test_n):
    ans = ((b0 + carats_test[i] * b1) - price_test_mean) ** 2
    sum_of_price_test_prediction_difference += ans
    print('{0:.0f}'.format(ans))
print('Suma kwadratów różnic: ', sum_of_price_test_prediction_difference)

# Obliczanie R^2
ss_numerator = 0
ss_denominator = 0
for i in range(number_of_examples):
    y_predicted = b0 + b1 * carats_test[i]
    ss_numerator += ((price_test[i] - mean_Y) - y_predicted) ** 2
    ss_denominator += (price_test[i] - mean_Y) ** 2
r2 = ss_numerator / ss_denominator
print('R2: ', r2)

# Prezentowanie danych na rysunku, aby były bardziej zrozumiałe.
fig = plt.figure()
plt.figure(num=None, figsize=(5, 5), dpi=300, facecolor='w', edgecolor='w')

# Pierwotne dane treningowe są koloru czerwonego.
plt.scatter(carats, price, color='red', label='Wykres punktowy')
# Dane testowe są koloru czarnego.
plt.scatter(carats_test, price_test, color='black', label='Wykres punktowy')
# Szare linie reprezentują średnie wartości x i y.
plt.axvline(x=mean_X, color='gray')
plt.axhline(y=mean_Y, color='gray')
# Rysowanie linii regresji, używając minimalnej i maksymalnej wartości karatów.
rex_x = [300, 2210]
rex_y = [515.7, 6511.19]
plt.plot(rex_x, rex_y, color='green')
# Dodawanie legendy rysunku, zapisywanie go i wyświetlanie.
plt.xlabel('Karaty')
plt.ylabel('Cena')
plt.savefig('karaty_od_ceny_wykres.png')
plt.show()
