unit Sort;

  { Ten modul zawiera opisy procedur porzadkowania, ktore sa realizacjami
    algorytmow porzadkowania liczb, omowionych w rozdz. 6 i 10.
    Zamieszczono rowniez opisy dwoch algorytmow, ktore nie sa omowione
    w ksiazce, HeapSort - stogowej metody porzadkowania oraz ShellSort -
    algorytmu Shella. Kazda procedura porzadkuje ciag liczb znajdujacy
    sie w tablicy x na pozycjach od Dol do Gora. Tablica x jest typu
    array[0..n] of integer, gdzie n jest stala.}

interface
 {R+}
 const n=1000;
 type
  Tablica1n=array[0..n] of integer;
   {Ze wzgledu na porzadkowanie przez umieszczanie, tablica
    porzadkowanych elementow musi miec element poprzedzajacy
    wszystkie pozostale, wykorzystany w tej metodzie jako
    wartownik.}

 procedure BubbleSort(Dol,Gora:integer; var x:Tablica1n);
  {Porzadkowanie metoda babelkowa, p. 6.1.}

 procedure HeapSort(Dol,Gora:integer; var x:Tablica1n);
  {Porzadkowanie metoda stogowa - brak opisu w ksiazce.}

 procedure InsertionSort(Dol,Gora:integer; var x:Tablica1n);
  {Porzadkowanie metoda przez umieszczanie, p. 10.1.}

 procedure MergeSort(Dol,Gora:integer; var x:Tablica1n);
  {Porzadkowanie metoda przez scalanie, p. 10.2.2.}

 procedure QuickSort(Dol,Gora:integer; var x:Tablica1n);
  {Porzadkowanie metoda szybka, p. 10.3.}

 procedure SelectionSort(Dol,Gora:integer; var x:Tablica1n);
  {Porzadkowanie metoda przez wybor, p. 6.2.}

 procedure ShellSort(Dol,Gora:integer; var x:Tablica1n);
  {Porzadkowanie metoda Shella - brak opisu w ksiazce.}

implementation

 procedure Przestaw(var u,w:integer);
   {Procedura przestawia element u z w.}
  var v:integer;
 begin
  v:=u;  u:=w;  w:=v
 end; {Przestaw}

 procedure BubbleSort(Dol,Gora:integer; var x:Tablica1n);
   {Porzadkowanie metoda babelkowa, p. 6.1.}
  var i,k,Kres:integer;
 begin
  Kres:=Gora;
  while Kres>Dol do begin
   k:=Dol;
   for i:=Dol to Kres-1 do
    if x[i]>x[i+1] then begin
     Przestaw(x[i],x[i+1]);
     k:=i
    end;
   Kres:=k
  end {while}
 end; {BubbleSort}

 procedure HeapSort(Dol,Gora:integer; var x:Tablica1n);
   {Porzadkowanie metoda stogowa - brak opisu w ksiazce.}
  var i:integer;
  procedure Przesiewanie(i,j:integer);
   var k:integer;
  begin
   k:=2*i;
   while k<=j do begin
    if k<j then if x[k]<x[k+1] then k:=k+1;
    if x[k]>x[i] then begin
     Przestaw(x[k],x[i]);
     i:=k;
     k:=i+i
    end
    else k:=j+1
   end {while}
  end; {Przesiewanie}
 begin
   { budowanie stogu }
  i:=(Gora-Dol+1) div 2;
  while i>=Dol do begin
   Przesiewanie(i,Gora);
   i:=i-1
  end;
   { sortowanie }
  i:=Gora;
  while i>Dol do begin
   Przestaw(x[Dol],x[i]);
   i:=i-1;
   Przesiewanie(1,i)
  end
 end; {HeapSort}

 procedure InsertionSort(Dol,Gora:integer; var x:Tablica1n);
   {Porzadkowanie metoda przez umieszczanie, p. 10.1.}
  var i,j,k,y:integer;
  function UmieszczanieBinarne(x:Tablica1n; k,l:integer;
                               y:integer):integer;
    {Znajdowanie miejsca dla elementu y za pomoca
     algorytmu binarnego umieszczania, p. 9.2.}
   var Lewy,Prawy,Srodek:integer;
  begin
   Lewy:=k;  Prawy:=l;
   repeat
    Srodek:=Lewy+Prawy;
    if Srodek mod 2 <> 0 then Srodek:=(Srodek+1) div 2
    else Srodek:=Srodek div 2;
     {Srodek jest rowny powale z polowy Lewy+Prawy.}
    if x[Srodek]<=y then Lewy:=Srodek
    else Prawy:=Srodek-1
   until Lewy=Prawy;
   UmieszczanieBinarne:=Lewy
  end; {UmieszczanieBinarne}

 begin
  x[0]:=-1;  {Wartownik przed pierwszym elementem.}
  for i:=2 to n do begin
   y:=x[i];
   k:=UmieszczanieBinarne(x,0,i-1,y);
   for j:=i-1 downto k+1 do x[j+1]:=x[j];
   x[k+1]:=y
  end {for}
 end; {InsertionSort}

 procedure MergeSort(Dol,Gora:integer; var x:Tablica1n);
   {Porzadkowanie metoda przez scalanie, p. 10.2.2.}
  var s:integer;
  procedure Scal(l,s,p:integer);
    {Scalanie podciagow uporzadkowanych x[l..s-1] i x[s..p]
     w ciag uporzadkowany x[l..p].}
   var i,j,k,m:integer;
       z      :Tablica1n;
  begin
   i:=l;  j:=s;  m:=l;
   while (i<s) and (j<=p) do begin
    if x[i]<=x[j] then begin
     z[m]:=x[i];  i:=i+1 end
    else begin z[m]:=x[j];  j:=j+1 end;
    m:=m+1
   end;  {while}
   if i<s then begin
    j:=s-1;  k:=p;
    while j>=i do begin
     x[k]:=x[j];
     k:=k-1;  j:=j-1
    end
   end;
   for i:=l to m-1 do x[i]:=z[i]
  end;  {Scal}
 begin {MergeSort}
  if Dol<Gora then begin
   s:=(Dol+Gora) div 2;
   MergeSort(Dol,s,x);
   MergeSort(s+1,Gora,x);
   Scal(Dol,s+1,Gora)
  end
 end; {MergeSort}

 procedure QuickSort(Dol,Gora:integer; var x:Tablica1n);
   {Porzadkowanie metoda szybka, p. 10.3.}
  procedure Sort(d,g:integer);
    {Rekurencyjne porzadkowanie ciagu w tablicy x[d..g].}
   var l,p,v:integer;
  begin
   l:=d;  p:=g;
   v:=x[(d+g) div 2];
    {Podzial ciagu elementem srodkowym.}
   repeat
    while x[l]<v do l:=l+1;
    while v<x[p] do p:=p-1;
    if l<=p then begin
     Przestaw(x[l],x[p]);
     l:=l+1;  p:=p-1
    end
   until l>p;
    {Porzadkowanie podciagow.}
   if d<p then Sort(d,p);
   if l<g then Sort(l,g)
  end; {Sort}
 begin {QuickSort}
  Sort(Dol,Gora)
 end; {QuickSort}

 procedure SelectionSort(Dol,Gora:integer; var x:Tablica1n);
   {Porzadkowanie metoda przez wybor, p. 6.2.}
  var i,j,k,xmin:integer;
 begin
  for i:=Dol to Gora-1 do begin
   k:=i;
   for j:=i+1 to Gora do
    if x[j]<x[k] then k:=j;
   Przestaw(x[k],x[i])
  end {for}
 end; {SelectionSort}

 procedure ShellSort(Dol,Gora:integer; var x:Tablica1n);
   {Porzadkowanie metoda Shella - brak opisu w ksiazce.}
  var j,k,Krok,y:integer;
 begin
  Krok:=1;
  while Krok<Gora-Dol+1 do Krok:=Krok+Krok;
  while Krok>1 do begin
   Krok:=Krok div 2;
   k:=Dol+Krok;
   while k<=Gora do begin
    y:=x[k];
    j:=k;
    while (j-Krok>=Dol) and (y<x[j-Krok]) do begin
     Przestaw(x[j],x[j-Krok]);
     j:=j-Krok
    end;
    x[j]:=y;
    k:=k+1
   end {while k }
  end {while Krok>1}
 end; {ShellSort}

end. {Unit Sort}
