/*****************************************************************************
*                                                                            *
*  ------------------------------- cvxhull.c ------------------------------  *
*                                                                            *
*****************************************************************************/

#include <math.h>
#include <stdlib.h>

#include "geometry.h"
#include "list.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- cvxhull -------------------------------  *
*                                                                            *
*****************************************************************************/

int cvxhull(const List *P, List *polygon) {

ListElmt           *element;

Point              *min,
                   *low,
                   *p0,
                   *pi,
                   *pc;

double             z,
                   length1,
                   length2;

int                count;

/*****************************************************************************
*                                                                            *
*  Szukanie najniszego punktu z listy.                                      *
*                                                                            *
*****************************************************************************/

min = list_data(list_head(P));

for (element = list_head(P); element != NULL; element = list_next(element)) {

   p0 = list_data(element);

   /**************************************************************************
   *                                                                         *
   *  Zapamitujemy najniszy dotd punkt.                                   *
   *                                                                         *
   **************************************************************************/

   if (p0->y < min->y) {

      min = p0;
      low = list_data(element);

      }

   else {

      /***********************************************************************
      *                                                                      *
      *  Jeli jest remis, wybieramy punkt najniszy i lewy.                 *
      *                                                                      *
      ***********************************************************************/

      if (p0->y == min->y && p0->x < min->x) {

         min = p0;
         low = list_data(element);

      }

   }

}

/*****************************************************************************
*                                                                            *
*  Inicjalizacja listy obrysu wypukego.                                     *
*                                                                            *
*****************************************************************************/

list_init(polygon, NULL);

/*****************************************************************************
*                                                                            *
*  Wykonujemy pochd Jarvisa w celu wyznaczenia obrysu wypukego.            *
*                                                                            *
*****************************************************************************/

p0 = low;

do {

   /**************************************************************************
   *                                                                         *
   *  Wstawiamy do obrysu nowy punkt p0.                                     *
   *                                                                         *
   **************************************************************************/

   if (list_ins_next(polygon, list_tail(polygon), p0) != 0) {

      list_destroy(polygon);
      return -1;

   }

   /**************************************************************************
   *                                                                         *
   *  Znajdujemy punkt pc pooone zgodnie z ruchem wskazwek zegara         *
   *  od wszystkich pozostaych punktw.                                     *
   *                                                                         *
   **************************************************************************/

   count = 0;

   for (element = list_head(P); element != NULL; element =
      list_next(element)) {

      /***********************************************************************
      *                                                                      *
      *  Pomijamy p0 z listy punktw.                                        *
      *                                                                      *
      ***********************************************************************/

      if ((pi = list_data(element)) == p0)
         continue;

      /***********************************************************************
      *                                                                      *
      *  Zliczamy liczb zbadanych punktw.                                  *
      *                                                                      *
      ***********************************************************************/

      count++;

      /***********************************************************************
      *                                                                      *
      *  Zakadamy, e pierwszy badany punkt ley zgodnie z ruchem wskazwek *
      *  zegara, pki nie okae si inaczej.                                 *
      *                                                                      *
      ***********************************************************************/

      if (count == 1) {

         pc = list_data(element);
         continue;

      }

      /***********************************************************************
      *                                                                      *
      *  Sprawdzenie, czy pi ley zgodnie z ruchem wskazwek zegara od pc.   *
      *                                                                      *
      ***********************************************************************/

      if ((z = ((pi->x - p0->x) * (pc->y - p0->y)) - ((pi->y - p0->y) * (pc->x
         - p0->x))) > 0) {

         /********************************************************************
         *                                                                   *
         *  Punkt pi jest pooony zgodnie z ruchem wskazwek zegara od pc.  *
         *                                                                   *
         ********************************************************************/

         pc = pi;

         }

      else if (z == 0) {

         /********************************************************************
         *                                                                   *
         *  Jeli pi i pc s wspliniowe, wybieramy dalszy od p0.           *
         *                                                                   *
         ********************************************************************/

         length1 = sqrt(pow(pi->x - p0->x, 2.0) + pow(pi->y - p0->y, 2.0));
         length2 = sqrt(pow(pc->x - p0->x, 2.0) + pow(pc->y - p0->y, 2.0));

         if (length1 > length2) {

            /*****************************************************************
            *                                                                *
            *  Punkt pi jest dalej od p0 ni pc.                             *
            *                                                                *
            *****************************************************************/

            pc = pi;

         }

      }

   }

   /**************************************************************************
   *                                                                         *
   *  Przygotowujemy si do znalezienia nastpnego punktu obrysu.            *
   *                                                                         *
   **************************************************************************/

   p0 = pc;

   /**************************************************************************
   *                                                                         *
   *  Kontynujemy, a wrcimy do najniszego punktu.                         *
   *                                                                         *
   **************************************************************************/

} while (p0 != low);

return 0;

}
