/*****************************************************************************
*                                                                            *
*  ------------------------------ bisearch.c ------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "search.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------- bisearch -------------------------------  *
*                                                                            *
*****************************************************************************/

int bisearch(void *sorted, const void *target, int size, int esize, int
   (*compare)(const void *key1, const void *key2)) {

int                left,
                   middle,
                   right;

/*****************************************************************************
*                                                                            *
*  Przeszukiwanie jest kontynuowane, a zetkn si indeksy left i right.     *
*                                                                            *
*****************************************************************************/

left = 0;
right = size - 1;

while (left <= right) {

   middle = (left + right) / 2;

   switch (compare(((char *)sorted + (esize * middle)), target)) {

      case -1:

      /***********************************************************************
      *                                                                      *
      *  Przygotowanie do szukania na prawo od indeksu middle.               *
      *                                                                      *
      ***********************************************************************/

      left = middle + 1;
      break;

      case 1:

      /***********************************************************************
      *                                                                      *
      *  Przygotowanie do szukania na lewo od indeksu middle.                *
      *                                                                      *
      ***********************************************************************/

      right = middle - 1;
      break;

      case 0:

      /***********************************************************************
      *                                                                      *
      *  Zwrcenie indeksu, pod ktrym znaleziono dane.                      *
      *                                                                      *
      ***********************************************************************/

      return middle;

   }

}

/*****************************************************************************
*                                                                            *
*  Zwrcenie informacji, e danych nie znaleziono.                           *
*                                                                            *
*****************************************************************************/

return -1;

}
