/*****************************************************************************
*                                                                            *
*  ------------------------------ geometry.h ------------------------------  *
*                                                                            *
*****************************************************************************/

#ifndef GEOMETRY_H
#define GEOMETRY_H

#include "list.h"

/*****************************************************************************
*                                                                            *
*  Przyblienie liczby pi.                                                   *
*                                                                            *
*****************************************************************************/

#ifndef PI
#define            PI                    3.14159
#endif

/*****************************************************************************
*                                                                            *
*  Makra suce do porwnywania.                                            *
*                                                                            *
*****************************************************************************/

#define            MIN(x, y)             (((x) < (y)) ? (x) : (y))
#define            MAX(x, y)             (((x) > (y)) ? (x) : (y))

/*****************************************************************************
*                                                                            *
*  Makra przeliczajce stopnie i radiany.                                    *
*                                                                            *
*****************************************************************************/

#define            DEGTORAD(deg)         (((deg) * 2.0 * PI) / 360.0)
#define            RADTODEG(rad)         (((rad) * 360.0) / (2.0 * PI))

/*****************************************************************************
*                                                                            *
*  Struktura na wsprzdne punktw w ukadzie prostoktnym.                 *
*                                                                            *
*****************************************************************************/

typedef struct Point_ {

double             x,
                   y,
                   z;

} Point;

/*****************************************************************************
*                                                                            *
*  Struktura na punkty opisane wsprzdnymi sferycznymi.                    *
*                                                                            *
*****************************************************************************/

typedef struct SPoint_ {

double             rho,
                   theta,
                   phi;

} SPoint;

/*****************************************************************************
*                                                                            *
*  --------------------------- Interfejs publiczny ------------------------  *
*                                                                            *
*****************************************************************************/

int lint(Point p1, Point p2, Point p3, Point p4);

int cvxhull(const List *P, List *polygon);

void arclen(SPoint p1, SPoint p2, double *length);

#endif
