/*****************************************************************************
*                                                                            *
*  ------------------------------- mgsort.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "sort.h"

/*****************************************************************************
*                                                                            *
*  --------------------------------- merge --------------------------------  *
*                                                                            *
*****************************************************************************/

static int merge(void *data, int esize, int i, int j, int k, int (*compare)
   (const void *key1, const void *key2)) {

char               *a = data,
                   *m;

int                ipos,
                   jpos,
                   mpos;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja licznikw zczania.                                        *
*                                                                            *
*****************************************************************************/

ipos = i;
jpos = j + 1;
mpos = 0;

/*****************************************************************************
*                                                                            *
*  Rezerwacja pamicia na zczane elementy.                                 *
*                                                                            *
*****************************************************************************/

if ((m = (char *)malloc(esize * ((k - i) + 1))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Dziaamy, pki ktrakolwiek cz ma elementy do zczania.               *
*                                                                            *
*****************************************************************************/

while (ipos <= j || jpos <= k) {

   if (ipos > j) {

      /***********************************************************************
      *                                                                      *
      *  W lewej czci nie ma ju elementw do zczania.                   *
      *                                                                      *
      ***********************************************************************/

      while (jpos <= k) {

         memcpy(&m[mpos * esize], &a[jpos * esize], esize);
         jpos++;
         mpos++;

      }

      continue;

      }

   else if (jpos > k) {

      /***********************************************************************
      *                                                                      *
      *  W prawej czci nie ma ju elementw do zczania.                  *
      *                                                                      *
      ***********************************************************************/

      while (ipos <= j) {

         memcpy(&m[mpos * esize], &a[ipos * esize], esize);
         ipos++;
         mpos++;

      }

      continue;

   }

   /**************************************************************************
   *                                                                         *
   *  Doczenie do zczonych elementw nastpnego elementu.                *
   *                                                                         *
   **************************************************************************/

   if (compare(&a[ipos * esize], &a[jpos * esize]) < 0) {

      memcpy(&m[mpos * esize], &a[ipos * esize], esize);
      ipos++;
      mpos++;

      }

   else {

      memcpy(&m[mpos * esize], &a[jpos * esize], esize);
      jpos++;
      mpos++;

   }

}

/*****************************************************************************
*                                                                            *
*  Przygotowanie do przekazania z powrotem zczonych danych.                *
*                                                                            *
*****************************************************************************/

memcpy(&a[i * esize], m, esize * ((k - i) + 1));

/*****************************************************************************
*                                                                            *
*  Zwolnienie pamici uywanej na zczanie.                                 *
*                                                                            *
*****************************************************************************/

free(m);

return 0;

}

/*****************************************************************************
*                                                                            *
*  -------------------------------- mgsort --------------------------------  *
*                                                                            *
*****************************************************************************/

int mgsort(void *data, int size, int esize, int i, int k, int (*compare)
   (const void *key1, const void *key2)) {

int                j;

/*****************************************************************************
*                                                                            *
*  Koniec rekurencji, kiedy niemoliwe s dalsze podziay.                   *
*                                                                            *
*****************************************************************************/

if (i < k) {

   /**************************************************************************
   *                                                                         *
   *  Ustalenie, gdzie naley podzieli elementy.                            *
   *                                                                         *
   **************************************************************************/

   j = (int)(((i + k - 1)) / 2);

   /**************************************************************************
   *                                                                         *
   *  Rekurencyjne sortowanie dwch czci.                                  *
   *                                                                         *
   **************************************************************************/

   if (mgsort(data, size, esize, i, j, compare) < 0)
      return -1;

   if (mgsort(data, size, esize, j + 1, k, compare) < 0)
      return -1;

   /**************************************************************************
   *                                                                         *
   *  Zczanie dwch posortowanych czci w jeden zbir posortowany.        *
   *                                                                         *
   **************************************************************************/

   if (merge(data, esize, i, j, k, compare) < 0)
      return -1;

}

return 0;

}
