/*****************************************************************************
*                                                                            *
*  ------------------------------- issort.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "sort.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- issort --------------------------------  *
*                                                                            *
*****************************************************************************/

int issort(void *data, int size, int esize, int (*compare)(const void *key1,
   const void *key2)) {

char               *a = data;

void               *key;

int                i,
                   j;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na element key.                                          *
*                                                                            *
*****************************************************************************/

if ((key = (char *)malloc(esize)) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Kolejne wstawianie elementu key midzy elementy posortowane.              *
*                                                                            *
*****************************************************************************/

for (j = 1; j < size; j++) {

   memcpy(key, &a[j * esize], esize);
   i = j - 1;

   /**************************************************************************
   *                                                                         *
   *  Okrelenie poloenia, gdzie nale wstawi element key.                 *
   *                                                                         *
   **************************************************************************/

   while (i >= 0 && compare(&a[i * esize], key) > 0) {

      memcpy(&a[(i + 1) * esize], &a[i * esize], esize);
      i--;

   }

   memcpy(&a[(i + 1) * esize], key, esize);

}

/*****************************************************************************
*                                                                            *
*  Zwolnienie pamici zaalokowanej na potrzeby sortowania.                   *
*                                                                            *
*****************************************************************************/

free(key);

return 0;

}
