# ****************************************************************************
# *                                                                          *
# *  spell.mak                                                               *
# *  =========                                                               * 
# *                                                                          *
# ****************************************************************************

# ****************************************************************************
# *                                                                          *
# *  Nazwa pliku makefile.                                                   *
# *                                                                          *
# ****************************************************************************

MAKNAM = spell.mak

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw bibliotek.                     *
# *                                                                          *
# ****************************************************************************

LIBDRS =

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw wczanych.                    *
# *                                                                          *
# ****************************************************************************

INCDRS = -I$(ALGOWC_TOPDIR)/include

# ****************************************************************************
# *                                                                          *
# *  Pliki bibliotek.                                                        *
# *                                                                          *
# ****************************************************************************

LIBFLS =

# ****************************************************************************
# *                                                                          *
# *  Pliki rdowe.                                                         *
# *                                                                          *
# ****************************************************************************

SRCFLS = ex-2.c\
         $(ALGOWC_TOPDIR)/source/bisearch.c\
         $(ALGOWC_TOPDIR)/source/issort.c\
         $(ALGOWC_TOPDIR)/source/spell.c
         
# ****************************************************************************
# *                                                                          *
# *  Pliki z kodem porednim.                                                *
# *                                                                          *
# ****************************************************************************

OBJFLS = ex-2.o\
         $(ALGOWC_TOPDIR)/source/bisearch.o\
         $(ALGOWC_TOPDIR)/source/issort.o\
         $(ALGOWC_TOPDIR)/source/spell.o

# ****************************************************************************
# *                                                                          *
# *  Plik wykonywalny.                                                       *
# *                                                                          *
# ****************************************************************************

EXE    = ex-2.exe

# ****************************************************************************
# *                                                                          *
# *  Opcje kompilacji i konsolidacji.                                        *
# *                                                                          *
# ****************************************************************************

CC     = c89
LL     = c89
CFLAGS =
LFLAGS =

# ****************************************************************************
# *                                                                          *
# *  Reguy.                                                                 *
# *                                                                          *
# ****************************************************************************

$(EXE): $(OBJFLS)
	$(LL) $(LFLAGS) -o $@ $(OBJFLS) $(LIBDRS) $(LIBFLS)

.c.o:
	$(CC) $(CFLAGS) -o $@ -c $(INCDRS) $<

all:
	make -f $(MAKNAM) clean
	make -f $(MAKNAM) depend

depend:
	makedepend $(INCDRS) -f $(MAKNAM) $(SRCFLS)
	make -f $(MAKNAM) $(EXE)

clean:
	-rm $(EXE)
	-rm $(OBJFLS)

# NIE USUWA TEGO WIERSZA -- zapewnia on istnienie odpowiednich zalenoci.
