/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Description: Ilustracja uycia tablicy asocjacyjnej z otwartym            *
*               adresowaniem (rozdzia 8.)                                   *
*                                                                            *
*****************************************************************************/

#include <stdio.h>

#include "ohtbl.h"

/*****************************************************************************
*                                                                            *
*  Ustalenie rozmiaru tablicy asocjacyjnej.                                  *
*                                                                            *
*****************************************************************************/

#define            TBLSIZ               11

/*****************************************************************************
*                                                                            *
*  ------------------------------ match_char ------------------------------  *
*                                                                            *
*****************************************************************************/

static int match_char(const void *char1, const void *char2) {

/*****************************************************************************
*                                                                            *
*  Sprawdzenie, czy dwa znaki pasuj do siebie.                              *
*                                                                            *
*****************************************************************************/

return (*(const char *)char1 == *(const char *)char2);

}

/*****************************************************************************
*                                                                            *
*  ------------------------------- h1_char --------------------------------  *
*                                                                            *
*****************************************************************************/

static int h1_char(const void *key) {

/*****************************************************************************
*                                                                            *
*  Uproszczona pomocnicza funkcja mieszajca.                                *
*                                                                            *
*****************************************************************************/

return *(const char *)key % TBLSIZ;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------- h2_char --------------------------------  *
*                                                                            *
*****************************************************************************/

static int h2_char(const void *key) {

/*****************************************************************************
*                                                                            *
*  Uproszczona pomocnicza funkcja mieszajca.                                *
*                                                                            *
*****************************************************************************/

return 1 + (*(const char *)key % (TBLSIZ - 2));

}

/*****************************************************************************
*                                                                            *
*  ------------------------------ print_table -----------------------------  *
*                                                                            *
*****************************************************************************/

static void print_table(const OHTbl *htbl) {

int                i;

/*****************************************************************************
*                                                                            *
*  Pokazanie tablicy asocjacyjnej z otwartym adresowaniem.                   *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar tablicy to %d\n", ohtbl_size(htbl));

for (i = 0; i < TBLSIZ; i++) {

   if (htbl->table[i] != NULL && htbl->table[i] != htbl->vacated) {

      fprintf(stdout, "Slot[%03d]=%c\n", i, *(char *)htbl->table[i]);

      }

   else {

      fprintf(stdout, "Slot[%03d]= \n", i);

   }

}

return;

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

OHTbl              htbl;

char               *data,
                   c;

int                retval,
                   i,
                   j;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja tablicy asocjacyjnej z otwartym adresowaniem.               *
*                                                                            *
*****************************************************************************/

if (ohtbl_init(&htbl, TBLSIZ, h1_char, h2_char, match_char, free) != 0)
   return 1;

/*****************************************************************************
*                                                                            *
*  Wykonanie rnych operacji na tablicy asocjacyjnej z otwartym adresowaniem*
*                                                                            *
*****************************************************************************/

for (i = 0; i < 5; i++) {

   if ((data = (char *)malloc(sizeof(char))) == NULL)
      return 1;

   /**************************************************************************
   *                                                                         *
   *  Ponisze wyraenie daje "losowe" dane bez powtrze.                   *
   *                                                                         *
   **************************************************************************/

   *data = ((8 + (i * 9)) % 23) + 'A';

   fprintf(stdout, "Mieszanie %c:", *data);

   for (j = 0; j < TBLSIZ; j++)
      fprintf(stdout," %02d", (h1_char(data) + (j * h2_char(data))) % TBLSIZ);

   fprintf(stdout, "\n");

   if (ohtbl_insert(&htbl, data) != 0)
      return 1;

   print_table(&htbl);

}

for (i = 0; i < 5; i++) {

   if ((data = (char *)malloc(sizeof(char))) == NULL)
      return 1;

   /**************************************************************************
   *                                                                         *
   *  Ponisze wyraenie dzia podobnie jak powysze, ale powoduje konflikty*
   *                                                                         *
   **************************************************************************/

   *data = ((8 + (i * 9)) % 13) + 'j';

   fprintf(stdout, "Mieszanie %c:", *data);

   for (j = 0; j < TBLSIZ; j++)
      fprintf(stdout," %02d", (h1_char(data) + (j * h2_char(data))) % TBLSIZ);

   fprintf(stdout, "\n");

   if (ohtbl_insert(&htbl, data) != 0)
      return 1;

   print_table(&htbl);

}

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'R';

if ((retval = ohtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba ponownego wstawienia R...Warto=%d (1=OK)\n", retval);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'n';

if ((retval = ohtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba ponownego wwstawienia n...Warto=%d (1=OK)\n", retval);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'o';

if ((retval = ohtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba ponownego wstawienia o...Warto=%d (1=OK)\n", retval);

fprintf(stdout, "Usuwanie R, n, i o\n");

c = 'R';
data = &c;

if (ohtbl_remove(&htbl, (void **)&data) == 0)
   free(data);

c = 'n';
data = &c;

if (ohtbl_remove(&htbl, (void **)&data) == 0)
   free(data);

c = 'o';
data = &c;

if (ohtbl_remove(&htbl, (void **)&data) == 0)
   free(data);

print_table(&htbl);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'R';

if ((retval = ohtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Mieszanie %c:", *data);

for (j = 0; j < TBLSIZ; j++)
   fprintf(stdout, " %02d", (h1_char(data) + (j * h2_char(data))) % TBLSIZ);

fprintf(stdout, "\n");

fprintf(stdout, "Prba ponownego wstawienia R...Warto=%d (0=OK)\n", retval);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'n';

if ((retval = ohtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Mieszanie %c:", *data);

for (j = 0; j < TBLSIZ; j++)
   fprintf(stdout, " %02d", (h1_char(data) + (j * h2_char(data))) % TBLSIZ);

fprintf(stdout, "\n");

fprintf(stdout, "Prba ponownego wstawienia n...Warto=%d (0=OK)\n", retval);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'o';

if ((retval = ohtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Mieszanie %c:", *data);

for (j = 0; j < TBLSIZ; j++)
   fprintf(stdout, " %02d", (h1_char(data) + (j * h2_char(data))) % TBLSIZ);

fprintf(stdout, "\n");

fprintf(stdout, "Prba ponownego wstawienai o...Warto=%d (0=OK)\n", retval);

print_table(&htbl);

fprintf(stdout, "Wstawianie X\n");

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'X';

if (ohtbl_insert(&htbl, data) != 0)
   return 1;

print_table(&htbl);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'Y';

if ((retval = ohtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba wstawienia do penej tablicy...Warto=%d (-1=OK)\n",
   retval);

c = 'o';
data = &c;

if (ohtbl_lookup(&htbl, (void **)&data) == 0)
   fprintf(stdout, "Znaleziono wystpienie o\n");
else
   fprintf(stdout, "Nie znaleziono wystapienia X\n");

c = 'Z';
data = &c;

if (ohtbl_lookup(&htbl, (void **)&data) == 0)
   fprintf(stdout, "Znaleziono wystpienie Z\n");
else
   fprintf(stdout, "Nie znaleziono wystpienia Z\n");

/*****************************************************************************
*                                                                            *
*  Usunicie tablicy asocjacyjnej z otwartym adresowaniem.                   *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "usuwanie tablicy asocjacyjnej.\n");
ohtbl_destroy(&htbl);

return 0;

}
