# ****************************************************************************
# *                                                                          *
# *  compress.mak                                                            *
# *  ============                                                            * 
# *                                                                          *
# ****************************************************************************

# ****************************************************************************
# *                                                                          *
# *  Nazwa pliku makefile.                                                   *
# *                                                                          *
# ****************************************************************************

MAKNAM = compress.mak

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw bibliotek.                     *
# *                                                                          *
# ****************************************************************************

LIBDRS =

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw nagwkowych.                  *
# *                                                                          *
# ****************************************************************************

INCDRS = -I$(ALGOWC_TOPDIR)/include

# ****************************************************************************
# *                                                                          *
# *  Pliki bibliotek.                                                        *
# *                                                                          *
# ****************************************************************************

LIBFLS =

# ****************************************************************************
# *                                                                          *
# *  Pliki rdowe.                                                         *
# *                                                                          *
# ****************************************************************************

SRCFLS = ex-1.c\
         $(ALGOWC_TOPDIR)/source/bit.c\
         $(ALGOWC_TOPDIR)/source/bitree.c\
         $(ALGOWC_TOPDIR)/source/heap.c\
         $(ALGOWC_TOPDIR)/source/huffman.c\
         $(ALGOWC_TOPDIR)/source/lz77.c
         
# ****************************************************************************
# *                                                                          *
# *  Pliki z kodem porednim.                                                *
# *                                                                          *
# ****************************************************************************

OBJFLS = ex-1.o\
         $(ALGOWC_TOPDIR)/source/bit.o\
         $(ALGOWC_TOPDIR)/source/bitree.o\
         $(ALGOWC_TOPDIR)/source/heap.o\
         $(ALGOWC_TOPDIR)/source/huffman.o\
         $(ALGOWC_TOPDIR)/source/lz77.o

# ****************************************************************************
# *                                                                          *
# *  Plik wykonywalny.                                                       *
# *                                                                          *
# ****************************************************************************

EXE    = ex-1.exe

# ****************************************************************************
# *                                                                          *
# *  Opcje kompilacji i konsolidacji.                                        *
# *                                                                          *
# ****************************************************************************

CC     = c89
LL     = c89
CFLAGS = -D_HPUX_SOURCE
LFLAGS =

# ****************************************************************************
# *                                                                          *
# *  Reguy.                                                                 *
# *                                                                          *
# ****************************************************************************

$(EXE): $(OBJFLS)
	$(LL) $(LFLAGS) -o $@ $(OBJFLS) $(LIBDRS) $(LIBFLS)

.c.o:
	$(CC) $(CFLAGS) -o $@ -c $(INCDRS) $<

all:
	make -f $(MAKNAM) clean
	make -f $(MAKNAM) depend

depend:
	makedepend $(INCDRS) -f $(MAKNAM) $(SRCFLS)
	make -f $(MAKNAM) $(EXE)

clean:
	-rm $(EXE)
	-rm $(OBJFLS)

# NIE USUWA TEGO WIERSZA -- zapewnia istnienie odpowiednich zalenoci.
