# ****************************************************************************
# *                                                                          *
# *  bitree.mak                                                              *
# *  ==========                                                              * 
# *                                                                          *
# ****************************************************************************

# ****************************************************************************
# *                                                                          *
# *  Nazwa pliku makefile.                                                   *
# *                                                                          *
# ****************************************************************************

MAKNAM = bitree.mak

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka bibliotek.                            *
# *                                                                          *
# ****************************************************************************

LIBDRS =

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw wczanych.                    *
# *                                                                          *
# ****************************************************************************

INCDRS = -I$(ALGOWC_TOPDIR)/include

# ****************************************************************************
# *                                                                          *
# *  Pliki bibliotek.                                                        *
# *                                                                          *
# ****************************************************************************

LIBFLS =

# ****************************************************************************
# *                                                                          *
# *  Pliki rdowe.                                                         *
# *                                                                          *
# ****************************************************************************

SRCFLS = ex-1.c\
         $(ALGOWC_TOPDIR)/source/bitree.c
         
# ****************************************************************************
# *                                                                          *
# *  Pliki z kodem porednim.                                                *
# *                                                                          *
# ****************************************************************************

OBJFLS = ex-1.o\
         $(ALGOWC_TOPDIR)/source/bitree.o

# ****************************************************************************
# *                                                                          *
# *  Plik wykonywalny.                                                       *
# *                                                                          *
# ****************************************************************************

EXE    = ex-1.exe

# ****************************************************************************
# *                                                                          *
# *  Opcje kompilacji i konsolidacji.                                        *
# *                                                                          *
# ****************************************************************************

CC     = c89
LL     = c89
CFLAGS =
LFLAGS =

# ****************************************************************************
# *                                                                          *
# *  Reguy.                                                                 *
# *                                                                          *
# ****************************************************************************

$(EXE): $(OBJFLS)
	$(LL) $(LFLAGS) -o $@ $(OBJFLS) $(LIBDRS) $(LIBFLS)

.c.o:
	$(CC) $(CFLAGS) -o $@ -c $(INCDRS) $<

all:
	make -f $(MAKNAM) clean
	make -f $(MAKNAM) depend

depend:
	makedepend $(INCDRS) -f $(MAKNAM) $(SRCFLS)
	make -f $(MAKNAM) $(EXE)

clean:
	-rm $(EXE)
	-rm $(OBJFLS)

# NIE USUWA TEGO WIERSZA -- zapewnia istnienie odpowiednich zalenoci.
