/*****************************************************************************
*                                                                            *
*  -------------------------------- root.c --------------------------------  *
*                                                                            *
*****************************************************************************/

#include <math.h>

#include "nummeths.h"

/*****************************************************************************
*                                                                            *
*  --------------------------------- root ---------------------------------  *
*                                                                            *
*****************************************************************************/

int root(double (*f)(double x), double (*g)(double x), double *x, int *n,
   double delta) {

int                satisfied,
                   i;

/*****************************************************************************
*                                                                            *
*  Metod Newtona znajdujemy pierwiastek f.                                  *
*                                                                            *
*****************************************************************************/

i = 0;
satisfied = 0;

while (!satisfied && i + 1 < *n) {

   /**************************************************************************
   *                                                                         *
   *  Przygotowujemy nastpn iteracj x.                                    *
   *                                                                         *
   **************************************************************************/

   x[i + 1] = x[i] - (f(x[i]) / g(x[i]));

   /**************************************************************************
   *                                                                         *
   *  Sprawdzamy, czy uzyskalimy dane przyblienie wartoci.              *
   *                                                                         *
   **************************************************************************/

   if (fabs(x[i + 1] - x[i]) < delta)
      satisfied = 1;

   /**************************************************************************
   *                                                                         *
   *  Przygotowanie do nastpnej iteracji.                                   *
   *                                                                         *
   **************************************************************************/

   i++;

}

/*****************************************************************************
*                                                                            *
*  Nawet jeli nie roblimy adnych iteracji, wskazujemy, e w x zapisano    *
*  jedn warto.                                                            *
*                                                                            *
*****************************************************************************/

if (i == 0)
   *n = 1;
else
   *n = i + 1;

/*****************************************************************************
*                                                                            *
*  Zwracamy informacj, czy znaleziono pierwiastek, czy wyczerpano           *
*  dopuszczaln liczb iteracji.                                             *
*                                                                            *
*****************************************************************************/

if (satisfied)
   return 0;
else
   return -1;

}
