/*****************************************************************************
*                                                                            *
*  --------------------------------- lex.c --------------------------------  *
*                                                                            *
*****************************************************************************/

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "chtbl.h"
#include "lex.h"
#include "symbol.h"

/*****************************************************************************
*                                                                            *
*  ---------------------------------- lex ---------------------------------  *
*                                                                            *
*****************************************************************************/

Token lex(const char *istream, CHTbl *symtbl) {

Token              token;

Symbol             *symbol;

int                length,
                   retval,
                   i;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na symbol.                                               *
*                                                                            *
*****************************************************************************/

if ((symbol = (Symbol *)malloc(sizeof(Symbol))) == NULL)
   return error;

/*****************************************************************************
*                                                                            *
*  Przetwarzanie nastpnego elementu leksykalnego.                           *
*                                                                            *
*****************************************************************************/

if ((symbol->lexeme = next_token(istream)) == NULL) {

   /**************************************************************************
   *                                                                         *
   *  Zwracamy informacj, e nie ma ju danych wejciowych.                 *
   *                                                                         *
   **************************************************************************/

   free(symbol);
   return lexit;

   }

else {

   /**************************************************************************
   *                                                                         *
   *  Okrelamy rodzaj elementu skadniowego.                                *
   *                                                                         *
   **************************************************************************/

   symbol->token = digit;
   length = strlen(symbol->lexeme);

   for (i = 0; i < length; i++) {

      if (!isdigit(symbol->lexeme[i]))
         symbol->token = other;

   }

   memcpy(&token, &symbol->token, sizeof(Token));

   /**************************************************************************
   *                                                                         *
   *  Wstawiamy symbol to tablicy symboli.                                   *
   *                                                                         *
   **************************************************************************/

   if ((retval = chtbl_insert(symtbl, symbol)) < 0) {

      free(symbol);
      return error;

      }

   else if (retval == 1) {

      /***********************************************************************
      *                                                                      *
      *  Symbol w tablicy symboli ju wqystpuje.                            *
      *                                                                      *
      ***********************************************************************/
      
      free(symbol);

   }

}

/*****************************************************************************
*                                                                            *
*  Zwracamy element skadniowy parserowi.                                    *
*                                                                            *
*****************************************************************************/

return token;

}
