/*****************************************************************************
*                                                                            *
*  ------------------------------- frames.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>

#include "frames.h"
#include "list.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ alloc_frame -----------------------------  *
*                                                                            *
*****************************************************************************/

int alloc_frame(List *frames) {

int                frame_number,
                   *data;

if (list_size(frames) == 0)

   /**************************************************************************
   *                                                                         *
   *  Informacja, e nie ma adnych ramek.                                   *
   *                                                                         *
   **************************************************************************/

   return -1;

else {

   if (list_rem_next(frames, NULL, (void **)&data) != 0)

      /***********************************************************************
      *                                                                      *
      *  Informacja, e nie mona byo pobra ramki.                         *
      *                                                                      *
      ***********************************************************************/

      return -1;

   else {

      /***********************************************************************
      *                                                                      *
      *  Zapis numeru dostpnej ramki.                                       *
      *                                                                      *
      ***********************************************************************/

      frame_number = *data;
      free(data);

   }

}

return frame_number;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------ free_frame ------------------------------  *
*                                                                            *
*****************************************************************************/

int free_frame(List *frames, int frame_number) {

int                *data;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na numer ramki.                                          *
*                                                                            *
*****************************************************************************/

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Zwrcenie ramki na list ramek dostnych.                                 *
*                                                                            *
*****************************************************************************/

*data = frame_number;

if (list_ins_next(frames, NULL, data) != 0)
   return -1;

return 0;

}
