/*****************************************************************************
*                                                                            *
*  ------------------------------ graphalg.h ------------------------------  *
*                                                                            *
*****************************************************************************/

#ifndef GRAPHALG_H
#define GRAPHALG_H

#include "graph.h"
#include "list.h"

/*****************************************************************************
*                                                                            *
*  Struktura na wzy drzew minimalnych.                                     *
*                                                                            *
*****************************************************************************/

typedef struct MstVertex_ {

void               *data;
double             weight;

VertexColor        color;
double             key;

struct MstVertex_  *parent;

} MstVertex;

/*****************************************************************************
*                                                                            *
*  Struktura na wzy najkrtszej cieki.                                   *
*                                                                            *
*****************************************************************************/

typedef struct PathVertex_ {

void               *data;
double             weight;

VertexColor        color;
double             d;

struct PathVertex_ *parent;

} PathVertex;

/*****************************************************************************
*                                                                            *
*  Struktura na wzy problemu komiwojaera.                                 *
*                                                                            *
*****************************************************************************/

typedef struct TspVertex_ {

void               *data;

double             x,
                   y;

VertexColor        color;

} TspVertex;

/*****************************************************************************
*                                                                            *
*  --------------------------- Interfejs publiczny ------------------------  *
*                                                                            *
*****************************************************************************/

int mst(Graph *graph, const MstVertex *start, List *span, int (*match)(const
   void *key1, const void *key2));

int shortest(Graph *graph, const PathVertex *start, List *paths, int (*match)
   (const void *key1, const void *key2));

int tsp(List *vertices, const TspVertex *start, List *tour, int (*match)
   (const void *key1, const void *key2));

#endif
