/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustracja uycia zbiorw (rozdzia 7.)                             *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "list.h"
#include "set.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------- print_set ------------------------------  *
*                                                                            *
*****************************************************************************/

static void print_set(const Set *set) {

ListElmt           *member;

int                *data,
                   size,
                   i;

/*****************************************************************************
*                                                                            *
*  Prezentacja zbioru.                                                       *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar zbioru to %d\n", size = set_size(set));

i = 0;
member = list_head(set);

while (i < size) {

   data = list_data(member);
   fprintf(stdout, "set[%03d]=%03d\n", i, *data);
   member = list_next(member);
   i++;

}

return;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------- match_int ------------------------------  *
*                                                                            *
*****************************************************************************/

static int match_int(const void *key1, const void *key2) {

/*****************************************************************************
*                                                                            *
*  Sprawdzenie, czy dwie liczby cakowite pasuj do siebie.                  *
*                                                                            *
*****************************************************************************/

return !memcmp(key1, key2, sizeof(int));

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

Set                set,
                   set1,
                   set2;

int                *data,
                   retval,
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja zbioru.                                                     *
*                                                                            *
*****************************************************************************/

set_init(&set, match_int, free);

/*****************************************************************************
*                                                                            *
*  Wykonanie operacji na zbiorze.                                            *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Wstawienie 10 elementw.\n");

for (i = 9; i >= 0; i--) {

   if ((data = (int *)malloc(sizeof(int))) == NULL)
      return 1;

   *data = i + 1;

   if ((retval = set_insert(&set, data)) < 0)
      return 1;
   else if (retval == 1)
      free(data);

}

print_set(&set);

fprintf(stdout, "Wstawienie takich samych elementw\n");

for (i = 9; i >= 0; i--) {

   if ((data = (int *)malloc(sizeof(int))) == NULL)
      return 1;

   *data = i + 1;

   if ((retval = set_insert(&set, data)) < 0)
      return 1;
   else if (retval == 1)
      free(data);

}

print_set(&set);

fprintf(stdout, "Wstawianie 200 i 100\n");

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return 1;

*data = 200;

if ((retval = set_insert(&set, data)) < 0)
   return 1;
else if (retval == 1)
   free(data);

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return 1;

*data = 100;

if ((retval = set_insert(&set, data)) < 0)
   return 1;
else if (retval == 1)
   free(data);

print_set(&set);

fprintf(stdout, "Usuwanie 100, 5 i 10\n");

i = 100;
data = &i;

if (set_remove(&set, (void **)&data) == 0)
   free(data);

i = 5;
data = &i;

if (set_remove(&set, (void **)&data) == 0)
   free(data);

i = 10;
data = &i;

if (set_remove(&set, (void **)&data) == 0)
   free(data);

print_set(&set);

fprintf(stdout, "Usuwanie trzech elementw\n");

if (list_rem_next(&set, NULL, (void **)&data) == 0)
   free(data);

if (list_rem_next(&set, NULL, (void **)&data) == 0)
   free(data);

if (list_rem_next(&set, NULL, (void **)&data) == 0)
   free(data);

print_set(&set);

fprintf(stdout, "Usuwanie wszystkich elementw\n");

while (set_size(&set) > 0) {

   if (list_rem_next(&set, NULL, (void **)&data) == 0)
      free(data);
   
}

print_set(&set);

/*****************************************************************************
*                                                                            *
*  Inicjalizacja dwch zbiorw.                                              *
*                                                                            *
*****************************************************************************/

set_init(&set1, match_int, free);
set_init(&set2, match_int, free);

/*****************************************************************************
*                                                                            *
*  Wykonywanie operacji na zbiorach.                                         *
*                                                                            *
*****************************************************************************/

for (i = 9; i >= 0; i--) {

   if ((data = (int *)malloc(sizeof(int))) == NULL)
      return 1;

   *data = i + 1;

   if ((retval = set_insert(&set1, data)) < 0)
      return 1;
   else if (retval == 1)
      free(data);

   if (i == 5 || i == 6 || i == 7) {

      if ((data = (int *)malloc(sizeof(int))) == NULL)
         return 1;

      *data = i * 10;

      if ((retval = set_insert(&set2, data)) < 0)
         return 1;
      else if (retval == 1)
         free(data);

      }

   else if (i == 3 || i == 1) {

      if ((data = (int *)malloc(sizeof(int))) == NULL)
         return 1;

      *data = i;

      if ((retval = set_insert(&set2, data)) < 0)
         return 1;
      else if (retval == 1)
         free(data);

   }

}

fprintf(stdout, "Zbir 1 do testowania sum, przecici i rnic\n");
print_set(&set1);
fprintf(stdout, "Zbir 2 do testowania sum, przecici i rnic\n");
print_set(&set2);

fprintf(stdout, "Okrelenie sumy dwch zbiorw\n");

if (set_union(&set, &set1, &set2) != 0)
   return 1;

print_set(&set);

fprintf(stdout, "Usunicie sumy\n");
set_destroy(&set);

fprintf(stdout, "Okrelenie przecicia dwch zbiorw\n");

if (set_intersection(&set, &set1, &set2) != 0)
   return 1;

print_set(&set);

fprintf(stdout, "Sprawdzenie, czy przecicie rwne jest zbiorowi 1...Warto=%d "
   "(0=OK)\n", set_is_equal(&set, &set1));

fprintf(stdout, "Sprawdzenie, czy zbir 1 jest rwny samemu sobie...Warto=%d (1=OK)\n",
   set_is_equal(&set1, &set1));

fprintf(stdout, "Sprawdzenie, czy przecicie jest podzbiorem zbioru 1..."
   "Warto=%d (1=OK)\n", set_is_subset(&set, &set1));

fprintf(stdout, "Sprawdzenie, czy zbir 2 jest podzbiorem zbioru 1...Warto=%d "
   "(0=OK)\n", set_is_subset(&set2, &set1));

fprintf(stdout, "Usuwanie przecicia\n");
set_destroy(&set);

fprintf(stdout, "Okrelenie rnicy dwch zbiorw\n");

if (set_difference(&set, &set1, &set2) != 0)
   return 1;

print_set(&set);

i = 3;
fprintf(stdout, "Sprawdzanie, czy %03d naley do rnicy...Warto=%d (0=OK)\n",i,
   set_is_member(&set, &i));

i = 5;
fprintf(stdout, "Sprawdzanie, czy %03d naley do rnicy...Warto=%d (1=OK)\n",i,
   set_is_member(&set, &i));

/*****************************************************************************
*                                                                            *
*  Usunicie zbiorw.                                                        *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usuwanie zbiorw\n");
set_destroy(&set);
set_destroy(&set1);
set_destroy(&set2);

return 0;

}
