# ****************************************************************************
# *                                                                          *
# *  geodist.mak                                                             *
# *  ===========                                                             * 
# *                                                                          *
# ****************************************************************************

# ****************************************************************************
# *                                                                          *
# *  Nazwa pliku makefile.                                                   *
# *                                                                          *
# ****************************************************************************

MAKNAM = geodist.mak

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka bibliotek.                            *
# *                                                                          *
# ****************************************************************************

LIBDRS =

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw nagwkowych.                  *
# *                                                                          *
# ****************************************************************************

INCDRS = -I$(ALGOWC_TOPDIR)/include

# ****************************************************************************
# *                                                                          *
# *  Pliki bibliotek.                                                        *
# *                                                                          *
# ****************************************************************************

LIBFLS = -lm

# ****************************************************************************
# *                                                                          *
# *  Pliki rdowe.                                                         *
# *                                                                          *
# ****************************************************************************

SRCFLS = ex-2.c\
         $(ALGOWC_TOPDIR)/source/arclen.c\
         $(ALGOWC_TOPDIR)/source/geodist.c
         
# ****************************************************************************
# *                                                                          *
# *  Pliki z kodem porednim.                                                *
# *                                                                          *
# ****************************************************************************

OBJFLS = ex-2.o\
         $(ALGOWC_TOPDIR)/source/arclen.o\
         $(ALGOWC_TOPDIR)/source/geodist.o

# ****************************************************************************
# *                                                                          *
# *  Plik wykonywalny.                                                       *
# *                                                                          *
# ****************************************************************************

EXE    = ex-2.exe

# ****************************************************************************
# *                                                                          *
# *  Reguy kompilacji i konsolidacji.                                       *
# *                                                                          *
# ****************************************************************************

CC     = c89
LL     = c89
CFLAGS =
LFLAGS =

# ****************************************************************************
# *                                                                          *
# *  Reguy.                                                                 *
# *                                                                          *
# ****************************************************************************

$(EXE): $(OBJFLS)
	$(LL) $(LFLAGS) -o $@ $(OBJFLS) $(LIBDRS) $(LIBFLS)

.c.o:
	$(CC) $(CFLAGS) -o $@ -c $(INCDRS) $<

all:
	make -f $(MAKNAM) clean
	make -f $(MAKNAM) depend

depend:
	makedepend $(INCDRS) -f $(MAKNAM) $(SRCFLS)
	make -f $(MAKNAM) $(EXE)

clean:
	-rm $(EXE)
	-rm $(OBJFLS)

# NIE USUWA TEGO WIERSZA -- zapewnia istnienie odpowiednich zalenoci.
