/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustruje operacje bitowe (rozdzia 14.)                            *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <string.h>

#include "bit.h"

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

unsigned char      bits1[8],
                   bits2[8],
                   bits3[8];

int                i;

/*****************************************************************************
*                                                                            *
*  Operacje bitowe na buforach 64-bitowych.                                  *
*                                                                            *
*****************************************************************************/


for (i = 0; i < 8; i++) {

   bits1[i] = 0x00;
   bits2[i] = 0x00;
   bits3[i] = 0x00;

}
 
fprintf(stdout, "Pocztkowo\n");

fprintf(stdout, "bits1: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits1[0],
   bits1[1], bits1[2], bits1[3], bits1[4], bits1[5], bits1[6], bits1[7]);

fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],
   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);

bit_set(bits1, 15, 1);
bit_set(bits1, 16, 1);
bit_set(bits1, 32, 1);
bit_set(bits1, 63, 1);
bit_set(bits2,  0, 1);
bit_set(bits2, 15, 1);

fprintf(stdout, "Po ustawieniu bitw 15, 16, 32, 63 w bits1 i bitw 00, 15 "
   "w bits2\n");

fprintf(stdout, "bits1: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits1[0],
   bits1[1], bits1[2], bits1[3], bits1[4], bits1[5], bits1[6], bits1[7]);

fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],
   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);

fprintf(stdout, "Bit 63 w bits1 to %d\n", bit_get(bits1, 63));
fprintf(stdout, "Bit 62 w bits1 to %d\n", bit_get(bits1, 62));
fprintf(stdout, "Bit 00 w bits2 to %d\n", bit_get(bits2,  0));
fprintf(stdout, "Bit 01 w bits2 to %d\n", bit_get(bits2,  1));

bit_xor(bits1, bits2, bits3, 32);

fprintf(stdout, "bits3 to bits1 XOR bits2 (32 bity)\n");

fprintf(stdout, "bits3: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits3[0],
   bits3[1], bits3[2], bits3[3], bits3[4], bits3[5], bits3[6], bits3[7]);

bit_xor(bits1, bits2, bits3, 64);

fprintf(stdout, "bits3 to bits1 XOR bits2 (64 bity)\n");

fprintf(stdout, "bits3: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits3[0],
   bits3[1], bits3[2], bits3[3], bits3[4], bits3[5], bits3[6], bits3[7]);

bit_rot_left(bits1, 64, 1);

fprintf(stdout, "Po przesuniciu bits1 w lewo x 1 (64 bity)\n");

fprintf(stdout, "bits1: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits1[0],
   bits1[1], bits1[2], bits1[3], bits1[4], bits1[5], bits1[6], bits1[7]);

bit_rot_left(bits2, 64, 1);

fprintf(stdout, "Po przesuniciu bits2 w lewo x 1 (64 bity)\n");

fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],
   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);

bit_rot_left(bits2, 16, 7);

fprintf(stdout, "Po przesuniciu bits2 w lewo x 7 (16 bitw)\n");

fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],
   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);

bit_rot_left(bits2, 8, 2);

fprintf(stdout, "Po przesuniciu bits2 w lewo x 2 (8 bitw)\n");

fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],
   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);

for (i = 0; i < 8; i++) {



   bits2[i] = 0x00;



}



bit_set(bits2,  0, 1);

bit_set(bits2,  3, 1);

bit_set(bits2,  8, 1);

bit_set(bits2, 27, 1);


fprintf(stdout, "Po wyzerowaniu i ustawieniu bitw 0, 3, 8, 27 w bits2\n");



fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],

   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);



bit_rot_left(bits2, 11, 6);



fprintf(stdout, "Po przesuniciu bits2 w lewo x 6 (11 bitw)\n");

fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],
   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);


for (i = 0; i < 8; i++) {



   bits2[i] = 0x00;



}



bit_set(bits2,  0, 1);

bit_set(bits2,  3, 1);

bit_set(bits2,  8, 1);

bit_set(bits2, 27, 1);



fprintf(stdout, "Po wyzerowaniu i ustawieniu bitw 0, 3, 8, 27 w bits2\n");



fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],

   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);



bit_rot_left(bits2, 28, 4);



fprintf(stdout, "Po przesuniciu bits2 w lewo x 4 (28 bitw)\n");



fprintf(stdout, "bits2: %02x %02x %02x %02x %02x %02x %02x %02x\n", bits2[0],

   bits2[1], bits2[2], bits2[3], bits2[4], bits2[5], bits2[6], bits2[7]);



return 0;

}
