/*****************************************************************************
*                                                                            *
*  ------------------------------- rxsort.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <limits.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "sort.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- rxsort --------------------------------  *
*                                                                            *
*****************************************************************************/

int rxsort(int *data, int size, int p, int k) {

int                *counts,
                   *temp;

int                index,
                   pval,
                   i,
                   j,
                   n;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na liczniki.                                             *
*                                                                            *
*****************************************************************************/

if ((counts = (int *)malloc(k * sizeof(int))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na elementy posortowane.                                 *
*                                                                            *
*****************************************************************************/

if ((temp = (int *)malloc(size * sizeof(int))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Sortowanie od pozycji najmniej znaczcej do najbardziej znaczcej.        *
*                                                                            *
*****************************************************************************/

for (n = 0; n < p; n++) {

   /**************************************************************************
   *                                                                         *
   *  Inicjalizacja licznikw.                                               *
   *                                                                         *
   **************************************************************************/

   for (i = 0; i < k; i++)
      counts[i] = 0;

   /**************************************************************************
   *                                                                         *
   *  Wyliczenie wartoci pozycji.                                           *
   *                                                                         *
   **************************************************************************/

   pval = (int)pow((double)k, (double)n);

   /**************************************************************************
   *                                                                         *
   *  Zliczanie wystpie poszczeglnych cyfr.                               *
   *                                                                         *
   **************************************************************************/

   for (j = 0; j < size; j++) {

      index = (int)(data[j] / pval) % k;
      counts[index] = counts[index] + 1;

   }

   /**************************************************************************
   *                                                                         *
   *  Korekta licznikw w celu uwzgldnienia licznikw je poprzedzajcych.   *
   *                                                                         *
   **************************************************************************/

   for (i = 1; i < k; i++)
      counts[i] = counts[i] + counts[i - 1];

   /**************************************************************************
   *                                                                         *
   *  Uycie licznikw do umieszczenia poszczeglnych elementw we waciwych*
   *  miejscach.                                                             *
   *                                                                         *
   **************************************************************************/

   for (j = size - 1; j >= 0; j--) {

      index = (int)(data[j] / pval) % k;
      temp[counts[index] - 1] = data[j];
      counts[index] = counts[index] - 1;

   }

   /**************************************************************************
   *                                                                         *
   *  Przygotowanie do zwrcenia posortowanych dotd danych.                 *
   *                                                                         *
   **************************************************************************/

   memcpy(data, temp, size * sizeof(int));

}

/*****************************************************************************
*                                                                            *
*  Zwolnienie pamici zaalokowanej na sortowanie.                            *
*                                                                            *
*****************************************************************************/

free(counts);
free(temp);

return 0;

}
