/*****************************************************************************
*                                                                            *
*  -------------------------------- cover.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>

#include "cover.h"
#include "list.h"
#include "set.h"

/*****************************************************************************
*                                                                            *
*  --------------------------------- cover --------------------------------  *
*                                                                            *
*****************************************************************************/

int cover(Set *members, Set *subsets, Set *covering) {

Set                intersection;

KSet               *subset;

ListElmt           *member,
                   *max_member;

void               *data;

int                max_size;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja pokrycia.                                                   *
*                                                                            *
*****************************************************************************/

set_init(covering, subsets->match, NULL);

/*****************************************************************************
*                                                                            *
*  Dziaamy, pki s niepokryte elementy i podzbiory do wyboru.              *
*                                                                            *
*****************************************************************************/

while (set_size(members) > 0 && set_size(subsets) > 0) {

   /**************************************************************************
   *                                                                         *
   *  Znajdowanie podzbioru pokrywajcego jak najwicej elementw.           *
   *                                                                         *
   **************************************************************************/

   max_size = 0;

   for (member = list_head(subsets); member != NULL; member =
      list_next(member)) {

      if (set_intersection(&intersection, &((KSet *)list_data(member))->set,
         members) != 0) {

         return -1;

      }

      if (set_size(&intersection) > max_size) {

         max_member = member;
         max_size = set_size(&intersection);

      }

      set_destroy(&intersection);

   }

   /**************************************************************************
   *                                                                         *
   *  Brak pokrycia, gdy brak przecicia s puste.                          *
   *                                                                         *
   **************************************************************************/

   if (max_size == 0)
      return 1;

   /**************************************************************************
   *                                                                         *
   *  Wstawienie do pokrycia wybranego podzbioru.                            *
   *                                                                         *
   **************************************************************************/

   subset = (KSet *)list_data(max_member);

   if (set_insert(covering, subset) != 0) 
      return -1;

   /**************************************************************************
   *                                                                         *
   *  Usunicie ze zbioru elementw bez pokrycia elementw, dla ktrych      *
   *  pokrycie wanie znalelimy.                                          *
   *                                                                         *
   **************************************************************************/

   for (member = list_head(&((KSet *)list_data(max_member))->set); member !=
      NULL; member = list_next(member)) {

      data = list_data(member);

      if (set_remove(members, (void**)&data) == 0 && members->destroy != NULL)
         members->destroy(data);

   }

   /**************************************************************************
   *                                                                         *
   *  Usunicie podzbioru ze zbioru podzbiorw do wykorzystania.             *
   *                                                                         *
   **************************************************************************/

   if (set_remove(subsets, (void **)&subset) != 0)
      return -1;

}

/*****************************************************************************
*                                                                            *
*  Jeli s elementy niepokryte, znalezienie pokrycia jest niemoliwe.       *
*                                                                            *
*****************************************************************************/

if (set_size(members) > 0)
   return -1;

return 0;

}
